/**  FinGoto1000Listener
 *     Interfaccia per farsi richiamare da chi vuol usare la finestra "FinGoto1000" per avere
 *     dall'utente un nome di place verso cui "migrare".
 *     @author     Luigi Antenucci
 *     @version    1.0
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.naming.PlaceID;


public interface FinGoto1000Listener {

      /**
       *  Metodo invocato dalla FinGoto1000 dopo che l'utente preme il bottone "migra".
       */ 
  public void eseguiAzioneGoto (PlaceID placeToGoTo) throws Exception;

      /**
       *  Metodi per disabilitare la finestra di chi invoca la FinGoto1000 - in caso che possano essere 
       *  alterati in essa dei dati che saranno usati nel metodo "eseguiAzioneGoto".
       */ 
  public void disabilitaFinestra ();
  public void abilitaFinestra();
  public void inPrimoPiano();

} //FinGoto1000Listener