/**  Debug
 *     La finestra di debug. Perch stampare su System.out quando si pu benissimo
 *     stampare su questa finestra che pu poi essere nascosta e attivata dinamicamente?
 *     Serve per stampare messaggi di debug in un'unica finestra.
 *     E' UN OGGETTO TOTALMENTE STATICO (tutti attributi e metodi "static").
 *     (versione per Swing della Debug usata nel mio progetto "Teatro").
 *     Usala!
 *     Nota: questo oggetto non  altro che un gestore di una finestra "debugWin".
 *     @autore     Luigi Antenucci
 *     @versione   2.0
 *     @linguaggio jdk 1.2
 */

package SOMA.gui;



public class Debug {

      /**
       *  La finestra di debug vera e propria.
       *  E` l'oggetto debugWin di riferimento.
       */
  protected static  DebugWindow debugWin = null;

      /**
       *  Apre la finestra di debug; se  gi aperta la pone in primo piano.
       */
  public static void apriFinestra () {
    if (debugWin == null)
      debugWin = new DebugWindow ();
    else
      debugWin.inPrimoPiano();
  } //creaFinestra

      /**
       *  Chiude la finestra di debug; se  gi chiusa non fa nulla.
       */
  public static void chiudiFinestra () {
    if (debugWin != null) {
      debugWin.distruggiFinestra ();
      debugWin = null;
    }
  } //distruggiFinestra

      /**
       *  Cancella il contenuto della finestra di debug (se  aperta).
       */
  public static void pulisciFinestra () {
    if (debugWin != null)
      debugWin.pulisci();
  } //pulisciFinestra

      /**
       *  Rende true se la finestra di debug  aperta (al momento).
       */
  public static boolean esisteFinestra () {
    return debugWin != null;
  } //esisteFinestra


  public static synchronized void out (String mess) {
    if (debugWin != null)
      debugWin.scrivi (mess);
  } //out


  public static synchronized void outln (String mess) {
    if (debugWin != null) 
      debugWin.scrivi (mess+"\n");
  } //outln

} //Debug