/**  AdvConfig
 *     Finestra per creare e visualizzare la "configurazione avanzata".
 *     Ha bisogno di un oggetto "anagrafe" a cui riferirsi.
 *     @author     Luigi Antenucci
 *     @version    5.5
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.gui.lingua.Lingua;
import SOMA.Environment;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.naming.PlaceID;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.tree.DefaultMutableTreeNode;


public class AdvConfig extends Finestra implements TreeSelectionListener {

      /**
       *  ICONE CARICATE UNA VOLTA SOLA ALLA CREAZIONE DELLA CLASSE!
       */
  protected static final ImageIcon IMG_ICO_CR_DOM  = new ImageIcon(PICTURE_PATH+"Persona.gif");
  protected static final ImageIcon IMG_ICO_CR_PLA  = new ImageIcon(PICTURE_PATH+"Personaggio.gif");
  protected static final ImageIcon IMG_ICO_CR_PMOB = new ImageIcon(PICTURE_PATH+"PersMobile.gif");
  protected static final ImageIcon IMG_ICO_FINPLA  = new ImageIcon(PICTURE_PATH+"Scrive.gif");
  protected static final ImageIcon IMG_ICO_FINDNS  = new ImageIcon(PICTURE_PATH+"DomainNS.gif");
  protected static final ImageIcon IMG_ICO_FINPNS  = new ImageIcon(PICTURE_PATH+"PlaceNS.gif");
  protected static final ImageIcon IMG_ICO_LANCAG  = new ImageIcon(PICTURE_PATH+"Agente.gif");
  protected static final ImageIcon IMG_ICO_CHIUDI  = new ImageIcon(PICTURE_PATH+"BotKO.gif");
  protected static final ImageIcon IMG_ICO_ZAMPINA = new ImageIcon(PICTURE_PATH+"Zampina.gif");

  // Variabili protette:
      /**
       *  Oggetti che mostrano frasi, coi che dipendono dalla lingua.
       */ 
  protected JButton     botCreaDom, botCreaPla, botCreaPMob,
                        botApriDNS, botApriPNS, botApriPlace,
                        botLanciaAg, botChiudi;
  protected PanChePlace panChePlace;
  protected PanMappe    panMappe;

  protected PanTestoSC  testata;

      /**
       *  Place correntemente selezionato tramite il pannello delle mappe
       */
  protected PlaceID placeCorrente;

      /**
       *  Qui ci memorizzo  l'unico oggetto "Anagrafe" (che non deve essere "null") da usare.
       */
  protected Anagrafe anagrafe;

      /**
       *  Qui ci memorizzo  l'oggetto "Anagrafe" usato precedentemente, cio in una finestra di
       *  "AdvConfig" creata precedentemente.
       *  E` un campo "STATICO" perch NON VOLGIO DIMENTICARMENE!
       *  Questo campo viene usato dal costruttore senza argomenti.
       */
  protected static Anagrafe anagrafePrecedente = new Anagrafe ();

      /**
       *  Qui tengo traccia se c' gi una finestra "AdvConfig" aperta.
       */
  protected static AdvConfig finGiaAperta = null;


      /**
       *  Costruzione della finestra per l'interazione con l'utente.
       */
  public AdvConfig (Anagrafe anagrafe) {
    this (anagrafe, null);
  } //costruttore

      /**
       *  Costruzione della finestra per l'interazione con l'utente.
       *  Permette di specificare anche il Place iniziale.
       */
  public AdvConfig (Anagrafe anagrafe, PlaceID placeIniziale) {
    super (10, 10);    // CHIAMO IL COSTRUTTORE DELLA SUPERCLASSE

    this.placeCorrente = placeIniziale;
    // Altrimenti, uso il l'ultimo place usato precedentemente
    this.anagrafe      = anagrafe;

    anagrafePrecedente = anagrafe;  // Salvo permanentemente l'anagrafe con cui sono stato creato!

    costruisciFinestra();

    finGiaAperta = this;  // Si ricorda l'ultima (e sola) finestra AdvConfig aperta

  } //costruttore

      /**
       *  Costruzione della finestra per l'interazione con l'utente.
       *  Poich NON viene passato un oggetto "Anagrafe", si user l'oggetto "Anagrafe"
       *  che ERA STATO PASSATO ALLA PRECEDENTE INVOCAZIONE!
       */
  public AdvConfig () {
    this (anagrafePrecedente, null);
  } //costruttore

      /**
       *  Costruzione della finestra per l'interazione con l'utente.
       *  Poich NON viene passato un oggetto "Anagrafe", si user l'oggetto "Anagrafe"
       *  che ERA STATO PASSATO ALLA PRECEDENTE INVOCAZIONE!
       *  Permette di specificare anche il Place iniziale.
       */
  public AdvConfig (PlaceID placeID) {
    this (anagrafePrecedente, placeID);
  } //costruttore

      /**
       *  Imposta l'anagrafe da usare alla successiva creazione.
       *  NB: NON DEVE ESSERE POSSIBILE LEGGERE DALL'ESTERNO L'OGGETTO "Anagrafe"!
       *  Se no tanto valeva che lo lasciassi totalmente "statico", come avevo pensato all'inizio!
       */
  public static void defAnagrafeFutura (Anagrafe anagrafe) {
    Debug.outln ("DEFINITA ANAGRAFE FUTURA: "+anagrafe.toString());
    anagrafePrecedente = anagrafe;  // Salvo permanentemente l'anagrafe con cui sono stato creato!
  } //defAnagrafeFutura

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#costruisciFinestra()}
       */
  public void costruisciFinestra () {
    InizioCostruisciFinestra ();       // PARTE INIZIALE DI COSTRUZIONE DELLA FINESTRA

    testata     = new PanTestoSC ();

    panChePlace = new PanChePlace (placeCorrente);

    panMappe    = new PanMappe (this, anagrafe);

    botCreaDom  = new JButton ();
    botCreaPla  = new JButton ();
    botCreaPMob = new JButton ();
    botApriDNS  = new JButton ();
    botApriPNS  = new JButton ();
    botApriPlace= new JButton ();
    botLanciaAg = new JButton ();
    botChiudi   = new JButton ();

    botCreaDom  .setCursor (cursoreBottone);
    botCreaPla  .setCursor (cursoreBottone);
    botCreaPMob .setCursor (cursoreBottone);
    botApriDNS  .setCursor (cursoreBottone);
    botApriPNS  .setCursor (cursoreBottone);
    botApriPlace.setCursor (cursoreBottone);
    botLanciaAg .setCursor (cursoreBottone);
    botChiudi   .setCursor (cursoreBottone);

    impostaFrasi ();         // IMPOSTA LE FRASI (DIPENDENTI DALLA LINGUA)

    impostaBottoni ();

    ListBottoni bottoniera = new ListBottoni(this);
    botCreaDom  .addActionListener (bottoniera);
    botCreaDom  .setActionCommand("CreaDominio");
    botCreaPla  .addActionListener (bottoniera);
    botCreaPla  .setActionCommand("CreaPlace");
    botCreaPMob .addActionListener (bottoniera);
    botCreaPMob .setActionCommand("CreaPMobile");
    botApriDNS  .addActionListener (bottoniera);
    botApriDNS  .setActionCommand("DomainNS");
    botApriPNS  .addActionListener (bottoniera);
    botApriPNS  .setActionCommand("PlaceNS");
    botApriPlace.addActionListener (bottoniera);
    botApriPlace.setActionCommand("ApriPlace");
    botLanciaAg .addActionListener (bottoniera);
    botLanciaAg .setActionCommand("LanciaAgente");
    botChiudi   .addActionListener (bottoniera);
    botChiudi   .setActionCommand("Chiudi");

    botCreaDom  .setIcon (IMG_ICO_CR_DOM);
    botCreaPla  .setIcon (IMG_ICO_CR_PLA);
    botCreaPMob .setIcon (IMG_ICO_CR_PMOB);
    botApriPlace.setIcon (IMG_ICO_FINPLA);
    botApriDNS  .setIcon (IMG_ICO_FINDNS);
    botApriPNS  .setIcon (IMG_ICO_FINPNS);
    botLanciaAg .setIcon (IMG_ICO_LANCAG);
    botChiudi   .setIcon (IMG_ICO_CHIUDI);
    botChiudi   .setPressedIcon(IMG_ICO_ZAMPINA);

    botChiudi.setVerticalTextPosition   (JButton.BOTTOM);
    botChiudi.setHorizontalTextPosition (JButton.CENTER);

    // USO Window Listener
    mioFrame.addWindowListener (bottoniera);

    GridBagLayout GBL     = new GridBagLayout();
    GridBagConstraints CC = new GridBagConstraints();
    PanCentro.setLayout (GBL);

    Component spazio;

    // AGGIUNGO SPAZIO VUOTO ATTORNO AL PANNELLO
    PanCentro.setBorder (BorderFactory.createEmptyBorder(10, 4, 2, 2));   // alto,sx,basso,dx

    CC.gridx = 1;   CC.gridy = 1;
    CC.anchor = GridBagConstraints.CENTER;
    CC.gridwidth = 10;
    GBL.setConstraints (testata, CC);
    PanCentro.add (testata);
    CC.gridwidth = 1;

    CC.anchor = GridBagConstraints.WEST;
    CC.gridx = 1;   CC.gridy = 2;
    CC.gridheight = 11;
    GBL.setConstraints (panMappe, CC);                    // Il pannello delle mappe
    PanCentro.add (panMappe);
    CC.gridheight = 1;

    spazio = Box.createRigidArea (new Dimension(5,25));   // Aggiunge spazio vuoto
    CC.gridx = 4;   CC.gridy = 2;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    spazio = Box.createRigidArea (new Dimension(10,5));   // E anche uno in verticale
    CC.gridx = 2;   CC.gridy = 3;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    // Stessa dimensione dei primi 2 bottoni: uso un PANNELLO CON GRID-LAYOUT
    JPanel panPiu = new JPanel(new GridLayout(2,2));  // 2 righe e 1 colonna
      panPiu.add (botCreaDom);
      panPiu.add (botCreaPMob);
      panPiu.add (botCreaPla);
    CC.gridx = 4;   CC.gridy = 3;  //NB: 4,3 (prima era 2,3)
    CC.anchor = GridBagConstraints.CENTER;
    CC.gridwidth = 2;
    GBL.setConstraints (panPiu, CC);
    PanCentro.add (panPiu);
    CC.gridwidth = 1;

    spazio = Box.createRigidArea (new Dimension(5,20));
    CC.gridx = 4;   CC.gridy = 4;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    JPanel panInput = new JPanel();
    panInput.setBorder (BorderFactory.createCompoundBorder(
                          BorderFactory.createBevelBorder(BevelBorder.RAISED, Color.white, Color.gray),
                          BorderFactory.createEmptyBorder(15, 8, 10, 8) ));   // alto,sx,basso,dx

    GridBagLayout GBL8     = new GridBagLayout();
    GridBagConstraints CC8 = new GridBagConstraints();
    panInput.setLayout (GBL8);

      CC8.gridx = 1;   CC8.gridy = 1;
      CC8.anchor = GridBagConstraints.CENTER;
      GBL8.setConstraints (panChePlace, CC8);
      panInput.add (panChePlace);

      spazio = Box.createRigidArea (new Dimension(5,15));   // Aggiunge spazio vuoto
      CC8.gridx = 1;   CC8.gridy = 3;
      GBL8.setConstraints (spazio, CC8);
      panInput.add (spazio);

      CC8.gridx = 1;   CC8.gridy = 5;
      GBL8.setConstraints (botApriPlace, CC8);
      panInput.add (botApriPlace);

      spazio = Box.createRigidArea (new Dimension(5,10));
      CC8.gridx = 1;   CC8.gridy = 7;
      GBL8.setConstraints (spazio, CC8);
      panInput.add (spazio);

      panPiu = new JPanel();
      GridBagLayout GBL3     = new GridBagLayout();
      GridBagConstraints CC3 = new GridBagConstraints();
      panPiu.setLayout (GBL3);
        CC3.fill = GridBagConstraints.VERTICAL;
        CC3.gridx = 1;   CC3.gridy = 1;
        GBL3.setConstraints (botApriDNS, CC3);
        panPiu.add (botApriDNS);
        CC3.gridx = 2;   CC3.gridy = 1;
        GBL3.setConstraints (botApriPNS, CC3);
        panPiu.add (botApriPNS);
      CC8.gridx = 1;   CC8.gridy = 8;
      GBL8.setConstraints (panPiu, CC8);
      panInput.add (panPiu);

      spazio = Box.createRigidArea (new Dimension(5,10));
      CC8.gridx = 1;   CC8.gridy = 9;
      GBL8.setConstraints (spazio, CC8);
      panInput.add (spazio);

      CC8.gridx = 1;   CC8.gridy = 10;
      GBL8.setConstraints (botLanciaAg, CC8);
      panInput.add (botLanciaAg);

    CC.gridx = 4;   CC.gridy = 6;
    GBL.setConstraints (panInput, CC);
    PanCentro.add (panInput);

    spazio = Box.createRigidArea (new Dimension(5,15));
    CC.gridx = 4;   CC.gridy = 7;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    spazio = Box.createRigidArea (new Dimension(7,5));  // Spazio verticale a sinistra
    CC.gridx = 5;   CC.gridy = 7;
    GBL.setConstraints (spazio, CC);
    PanCentro.add (spazio);

    CC.gridx = 4;   CC.gridy = 8;
    CC.anchor = GridBagConstraints.EAST;
    CC.gridwidth = 2;
    GBL.setConstraints (botChiudi, CC);
    PanCentro.add (botChiudi);

    FineCostruisciFinestra ();       // PARTE FINALE DI COSTRUZIONE DELLA FINESTRA
  } //costruisciFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#distruggiFinestra()}
       */
  public void distruggiFinestra () {
    panMappe.distruggimi();
    finGiaAperta = null;  // Non c' pi alcuna finestra aperta
    super.distruggiFinestra();
  } //distruggiFinestra

      /**
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#creaBarraMenu()}
       */
  protected void creaBarraMenu () {
    creaBarraMenuDefault (MENU_CLOSE);
  } //creaBarraMenu

      /**
       *  Definisce/modifica tutte le frasi mostrate a video (nella GUI)
       *  Vedi in superclasse {@link SOMA.gui.Finestra} il metodo {@link SOMA.gui.Finestra#impostaFrasi()}
       */
  protected void impostaFrasi () {
    mioFrame.setTitle (Lingua.frase("AC_WIN_TITLE"));

    testata.setText (Lingua.frase("AC_TESTATA"));

    if (placeCorrente != null)
      panChePlace.defFrase (Lingua.frase("AC_CHOOSE_PLACE"));

    botCreaDom  .setText (Lingua.frase("AC_NEW_DEFPLACE"));
    botCreaPla  .setText (Lingua.frase("AC_NEW_PLACE"));
    botCreaPMob .setText (Lingua.frase("AC_NEW_PMOBILE"));
    botApriPlace.setText (Lingua.frase("AC_OPEN_PLACE"));
    botApriDNS  .setText (Lingua.frase("AC_OPEN_DNS"));
    botApriPNS  .setText (Lingua.frase("AC_OPEN_PNS"));
    botLanciaAg .setText (Lingua.frase("AC_AGENT"));
    botChiudi   .setText (Lingua.frase("AC_CLOSE"));

    botCreaDom  .setToolTipText (Lingua.frase("AC_TIP_NEW_DEFPLACE"));
    botCreaPla  .setToolTipText (Lingua.frase("AC_TIP_NEW_PLACE"));
    botCreaPMob .setToolTipText (Lingua.frase("AC_TIP_NEW_PMOBILE"));
    botApriPlace.setToolTipText (Lingua.frase("AC_TIP_OPEN_PLACE"));
    botApriDNS  .setToolTipText (Lingua.frase("AC_TIP_OPEN_DNS"));
    botApriPNS  .setToolTipText (Lingua.frase("AC_TIP_OPEN_PNS"));
    botLanciaAg .setToolTipText (Lingua.frase("AC_TIP_AGENT"));
    botChiudi   .setToolTipText (Lingua.frase("AC_TIP_CLOSE"));

    FineImpostaFrasi();      // APPORTA ALLA FINESTRA LE MODIFICHE FATTE
  } //impostaFrasi

      /**
       *  Interna, serve per impostare lo stato dei bottoni in base allo stato (di un agente)
       *  che viene passato come parametro.
       */
  protected void impostaBottoni () {
    boolean abilita;
    if (placeCorrente == null) {
      panChePlace.defFrase (Lingua.frase("AC_CHOOSE_PLACE"));
      botApriDNS.setEnabled(false);
      abilita = false;
    }
    else {
      boolean abilitaDNS =  placeCorrente.isDomain() ||
                           (placeCorrente instanceof MobilePlaceID);
      botApriDNS.setEnabled(abilitaDNS);
      abilita = true;
    }
    botApriPNS  .setEnabled(abilita);
    botApriPlace.setEnabled(abilita);
    botLanciaAg .setEnabled(abilita);
  } //impostaBottoni

      /**
       *  Rende "true" se c' gi una finestra AdvConfig aperta sul video.
       */
  public static boolean esisteFinAperta() {
    return finGiaAperta != null;
  } //esisteFinAperta

      /**
       *  Rende il riferimento alla finestra di AdvConfig gi aperta a video
       *  oppure "null" se non c' nessuna finestra aperta.
       */
  public static AdvConfig rendiFinAperta() {
    return finGiaAperta;
  } //rendiFinAperta

      /**
       *  METODO RICHIESTO DELL'INTERFACCIA "TreeSelectionListener"
       *  Quando l'utente seleziona un nodo dell'albero in "panMappe"
       *  viene invocato questo metodo: devo USARE il nodo selezionato
       */
  public void valueChanged (TreeSelectionEvent e) {
    JTree albero = (JTree)e.getSource();
    if (albero != null) { // per sicurezza
      // Per prima cosa prelevo il nodo selezionato (lo so,  un po' compilcato; ma non  colpa mia)
      DefaultMutableTreeNode nodoSelez = (DefaultMutableTreeNode) albero.getLastSelectedPathComponent();
      Debug.outln ("SELEZIONATO ALBERO: "+e.getSource().toString());
      // E da/l nodo ricavo l'informazione utile (il PlaceID)
      if (nodoSelez != null) { // per ulteriore sicurezza (accadono eccezioni "strane" e casuali)
        Debug.outln ("            NODO: "+nodoSelez.toString());
        placeCorrente = (PlaceID) nodoSelez.getUserObject();
        // E aggiorno il video
        panChePlace.defPlace(placeCorrente);
      }
      else {
        Debug.outln ("            NESSUN NODO SELEZIONATO");
        placeCorrente = null;
      }
      impostaBottoni();  // Va bene: se c' "null", disabilita tutti i bottoni
    }
  } //valueChanged


      /**
       *  CLASSE INTERNA PER ASCOLTARE LA PRESSIONE DEI BOTTONI DELLA FINESTRA.
       */
  class ListBottoni extends WindowAdapter implements ActionListener {
    protected AdvConfig mioAdvConfig;

    public ListBottoni (AdvConfig mioAdvConfig) {
      this.mioAdvConfig = mioAdvConfig;
    } //costruttore

    public void actionPerformed (ActionEvent e) {
      String azione = e.getActionCommand();
      if (azione.equals("CreaDominio")) {
        PlaceID dominio;
        if (placeCorrente != null)
          dominio = placeCorrente.getDomainID();
        else
          dominio = null;
        DefPlaceDef nuovaFin = new DefPlaceDef (mioAdvConfig, true, dominio, anagrafe);
      } //if
      else
      if (azione.equals("CreaPlace")) {
        PlaceID dominio;
        if (placeCorrente != null)
          dominio = placeCorrente.getDomainID();
        else
          dominio = null;
        DefPlace nuovaFin = new DefPlace (mioAdvConfig, true, dominio, anagrafe);  // true=advanced
      }
      else
      if (azione.equals("CreaPMobile")) {
        PlaceID dominio;
        if (placeCorrente != null)
          dominio = placeCorrente.getDomainID();
        else
          dominio = null;
        DefPlaceMob nuovaFin = new DefPlaceMob (mioAdvConfig, true, dominio, anagrafe);  // true=advanced
      }
      else
      if (azione.equals("DomainNS")) {
        if (placeCorrente != null) {
          Environment env = anagrafe.cheEnvironment(placeCorrente);
          // Crea modello DNS - con finestra (con tutti i bottoni)!
          ModelloDNS modDNS = new ModelloDNS (env, FinestraXNS.MODIFICABILE);
        }
      }
      else
      if (azione.equals("PlaceNS")) {
        if (placeCorrente != null) {
          Environment env = anagrafe.cheEnvironment(placeCorrente);
          // Crea modello PNS - con finestra (con tutti i bottoni)!
          ModelloPNS modPNS = new ModelloPNS (env, FinestraXNS.MODIFICABILE);
        }
      }
      else
      if (azione.equals("ApriPlace")) {
        if (placeCorrente != null) {
          ActionPlace mioActionPlace = anagrafe.cheActionPlace (placeCorrente);
          if (mioActionPlace != null)
            try {
              mioActionPlace.start();      // Apro la finestra (ma solo se non lo  gi!)          	
            }
            catch (Exception E) {}
        }           
      }
      else
      if (azione.equals("LanciaAgente")) {
        if (placeCorrente != null) {
          ActionPlace mioActionPlace = anagrafe.cheActionPlace (placeCorrente);
          if (mioActionPlace != null) {
            LancioAgente LA = new LancioAgente (mioActionPlace, mioAdvConfig, anagrafe);
          }
        }
      }
      else  // in ogni caso considera un "Annulla"
        mioAdvConfig.distruggiFinestra();   // In ogni caso distruggo questa finestra
    } //actionPerf/ormed

    public void windowClosing (WindowEvent e) {
      mioAdvConfig.distruggiFinestra();     // distruggo questa finestra (torno a Inizio)
    } //windowClosing
  } //ListBottoni


/*
  public static void main (String[] args) {
    // PER DEBUGGING
    UIManager.installLookAndFeel ("Gigi", "SOMA.gui.gigi.GigiLookAndFeel");
    new AdvConfig();
  }
*/

} //AdvConfig