/**  ActionPlaceInterface
 *     Permette di stabilire quali sono i metodi "UTILI" di "ActionPlace" che vengono invocati
 *     da alcune particolari finestre.
 *     Tali "finestre" useranno l'interfaccia "ActionPlaceInterface" anzich l'oggetto "ActionPlace"
 *     e quindi possono essere RIUSATE da qualsiasi altro oggetto che implementa tale interfaccia.
 *     In particolare l'oggetto "DelegatePlace" (in SOMA.gui.remoteapplet") l'implementa.
 *     @author     Luigi Antenucci
 *     @version    1.1
 *     @language   jdk 1.2.2
 */

package SOMA.gui;

import SOMA.naming.PlaceID;
import java.util.Vector;
import javax.swing.tree.DefaultTreeModel;


public interface ActionPlaceInterface {

      /**
       *  Rende il {@link SOMA.naming.PlaceID} del place associato all'ActionPlace
       */
  public PlaceID chePlaceID ();

      /**
       *  Lancia un agente, in base ai dati passati.
       */
  public void lanciaAgente (String nomeAgente, String[] arrParam,
                            boolean usaSysClassLoader, boolean rintracciabile,
                            boolean nonFarloPartire) throws Exception;

      /**
       *  Rende la lista di tutti i nomi (sottoforma di stringa) degli agenti contenuti 
       *  nel Percorso degli Agenti del place.
       */
  public Vector cheElencoAgenti ();

      /**
       *  Rende la lista di tutti i PlaceID dei place contenuti nel DNS del place.
       */
  public Vector elencoDominiiInDNS ();

      /**
       *  Rende la lista di tutti i PlaceID dei place contenuti nel PNS del place.
       */
  public Vector elencoPlaceInPNS ();

      /**
       *  Rende un modello di un albero ({@link javax.swing.tree.DefaultTreeModel})
       *  il cui albero  costituito da nodi di classe {@link javax.swing.tree.DefaultMutableTreeNode}.
       *  Tale albero contiene tutti i thread attivi all'interno del Place di riferimento.
       *  Nota: ogni nodo contiene una STRINGA (e non un oggetto Thread!) che rappresenta la
       *  DESCRIZIONE del reltivo thread nel threadgroup.
       */
  public DefaultTreeModel alberoPlaceThread ();

      /**
       *  Rende una lista contenente una descrizione di tutti gli agenti
       *  che sono al momento in esecuzione.
       *  Ogni elemento della lista  a sua volta una lista, cio una terna:
       *    (AgentID, NomeClasse, Stato)
       *  Utile per il costruttore di JTable().
       */
  public Vector elencoAgentiInEsecuzione ();

      /**
       *  Rende una lista contenente la posizione di tutti gli agenti che sono
       *  stati creati nel Place.
       *  Ogni elemento della lista  a sua volta una lista, cio una coppia:
       *    (AgentID, PlaceID)
       *  Utile per il costruttore di JTable().
       */
  public Vector elencoPosizioneAgenti ();


} //ActionPlaceInterface