package SOMA.explorer;

import java.io.*;
import java.util.*;

/** Voce di menu che carica il file specificato come parametro e lo esegue.
*
* Il comando <I>"load filename"</I> esegue i comandi contenuti in <I>"filename"</I>
* come un comune file di script.
*
* @author Livio Profiri
*/
public class LoadExplorerItem extends ExplorerItem
{
  /** @serial*/
  DirExplorerItem dir;

  /** Costruttore che specifica il menu su cui far eseguire i comandi letti da file.
  * @param dir menu su cui far eseguire i comandi letti da file.
  */
  public LoadExplorerItem( DirExplorerItem dir )
  {
    super( "<fileName>" );
    this.dir = dir;
  }

  /** Apre il file indicato dal primo parametro e avvia un {@link SOMA.explorer.ExplorerThread}
  * che legge da quel file e fa echo su out.
  */

  public Object Execute( Collection Parameters, PrintStream out )
  {
    try
    {
      InputStream is = new FileInputStream( (String)Parameters.iterator().next() );

      new ExplorerThread( dir, is, out, true ).start();
    }
    catch( NoSuchElementException e )
    {
     out.println( "I need a filename to open!" );
    }
    catch( Exception e )
    {
      out.println( e );
    }
    return null;
  }
}