package SOMA.explorer;

import java.io.*;
import java.util.*;

/** Thread che rimane in attesa di input proveniente da un InputStream.
 *
 * @author Livio Profiri
 */
public class ExplorerThread extends Thread
{
  /** @serial*/
  PrintStream out;
  /** @serial*/
  BufferedReader brIn;
  /** @serial*/
  boolean Continue = true;
  /** @serial*/
  DirExplorerItem Dir, RootDir;
  //DirExplorerItem Dir;
  /** @serial*/
  boolean echo = false;

  /** Costruttore in cui si specifica solo il direttorio da esplorare: vengono utilizzati gli
   * stream di sistema e non viene fatta l'echo dei comandi inseriti.
   */
  public ExplorerThread( DirExplorerItem Dir )
  {
    this( Dir, System.in, System.out, false );
  }

  /** Costruttore in cui si specificano il direttorio da esplorare, un InputStream di ingresso,
   * un PrintStream di uscita e se e' necessario effettuare l'echo dei comandi inseriti in ingresso.
   */
  public ExplorerThread( DirExplorerItem dir, InputStream in, PrintStream out, boolean echo )
  {
    this( Thread.currentThread().getThreadGroup(), dir, in, out, echo );
  }

  /** Costruttore in cui si specificano il direttorio da esplorare, un InputStream di ingresso,
  * un PrintStream di uscita, se e' necessario effettuare l'echo dei comandi inseriti in ingresso
  * ed il ThreadGroup di appartenenza.
  */
  public ExplorerThread( ThreadGroup threadGroup, DirExplorerItem dir, InputStream in, PrintStream out, boolean echo )
  {
    super( threadGroup, "Explorer Thread" );

    // Non so se  necessario:
    /*
    try
    {
      setContextClassLoader(ClassLoader.getSystemClassLoader());
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }*/

    this.RootDir = this.Dir = dir;

    this.out = out;
    this.echo = echo;

    brIn = new BufferedReader( new InputStreamReader(in) );
  }

  /** Aggiunge la voce <B>exit</B> al menu principale.
   * Questa voce termina il thread attuale.
   */
  public void addExit()
  {
    RootDir.addItem( "exit", new ExplorerItem( "Terminates the explorer thread" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          Object returnValue = RootDir.removeItem( "exit" );
          //Object returnValue = Dir.removeItem( "exit" );
          out.println( " Rimosso:" + returnValue.toString() );
          Stop();

          return returnValue;
        }
      });
  }

  public void Stop()
  {
    try
    {
      brIn.close();
    }
    catch( IOException e )
    {
      e.printStackTrace( out );
    }

    Continue = false;
  }

  public void run()
  {
    try
    {
      String Linea;

      out.print( Dir.BuildPath() + "> " );
      while( Continue && (Linea = brIn.readLine()) != null )
      {
        try
        {
          if( echo )
            out.println( Linea );

          Object Result = Dir.Execute( Linea, out );

          out.println();
          out.println( "Result: " + Result );
          out.println();

          if( Result instanceof DirExplorerItem.ChangeDirMessage )
            Dir = ((DirExplorerItem.ChangeDirMessage)Result).targetDirectory;
        }
        catch( Exception e )
        {
          e.printStackTrace();
        }

        out.print( Dir.BuildPath() + "> " );
      }
    }
    catch( IOException e )
    {
      e.printStackTrace();
    }
  }

  /*

  // Esempio di utilizzo!!!!

  static public void main( String[] args )
  {
    DirExplorerItem Root = new DirExplorerItem( "root" );
    DirExplorerItem Note = new DirExplorerItem( "Note" );

    Note.addItem( new DirExplorerItem( "Do" ) );
    Note.addItem( new DirExplorerItem( "Re" ) );
    Note.addItem( new DirExplorerItem( "Mi" ) );
    Root.addItem( Note );

    DirExplorerItem Fiori = new DirExplorerItem( "Fiori" );

    Fiori.addItem( new DirExplorerItem( "Rosa" ) );
    Fiori.addItem( new DirExplorerItem( "Giglio" ) );
    Root.addItem( Fiori );

    DirExplorerItem Crono = new DirExplorerItem( "crono" );
    Crono.addItem( "uno", new Utility.ChronometerExplorerItem( "Crono uno" ));
    Crono.addItem( "due", new Utility.ChronometerExplorerItem( "Crono due" ));
    Crono.addItem( "tre", new Utility.ChronometerExplorerItem( "Crono tre" ));
    Root.addItem( Crono );

    DirExplorerItem socket = new DirExplorerItem( "socket" );
    socket.addItem( "threads", new Utility.ThreadsExplorerItem() );
    socket.addItem( "localHost", new Utility.GetLocalHostExplorerItem() );
    socket.addItem( "NewServer", new Network.NewServerExplorerItem( socket ) );
    socket.addItem( "NewClient", new Network.NewClientExplorerItem( socket ) );
    Root.addItem( socket );

    ExplorerThread Explorer = new ExplorerThread( Root );
    Explorer.start();
  }*/
}