package SOMA.explorer;

import java.io.*;
import java.util.*;

/**
* Un direttorio rappresenta un menu.
*
* Siccome un direttorio puo' contenere altri direttori DirExplorerItem
* e' sottoclasse di ExplorerItem.
*
* Le operazioni di base fornite all'utente sono:
* <UL>
* <I><LI>&lt;Invio&gt; </I>Visualizza il contenuto del direttorio (= <I>ls</I>)</LI>
* <I><LI>/ </I>Riferimento al direttorio radice.</LI>
* <I><LI>cd </I>Cambia direttorio.</LI>
* <I><LI>help </I>Ottiene aiuto su una voce del menu.</LI></UL>
*
* @author Livio Profiri
*/

public class DirExplorerItem extends ExplorerItem
{
  /** @serial*/
  private final Hashtable Items = new Hashtable();
  /** @serial*/
  private final List Index = Collections.synchronizedList(new ArrayList());

  /** @serial*/
  String DirectoryName;

  static public final String UpperLevelDirectoryString = "..";
  static public final String RootDirectoryString = "/";
  static final int EndPosition = -1;
  // root directory.

  /** Costruttore che specifica il nome del direttorio. */
  public DirExplorerItem( String DirectoryName )
  {
    this.DirectoryName = DirectoryName;
    Syntax = "Directory";

    addItem( "/", new ExplorerItem( "root directory" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          return FindRootDirectory().Execute( Parameters, out );
        }
      });

    addItem( "cd", new ChangeDirExplorerItem() );
    addItem( "help", new HelpExplorerItem() );

    /*
    addItem( "get", new ExplorerItem( "item path" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          return getItem( Parameters );
        }
      });*/
  }

  public String toString()
  {
    return "Directory: " + BuildPath();
  }

  /** Esegue il comando rappresentato da una stringa specificando il PrintStream di output.*/
  public Object Execute( String ParametersLine, PrintStream out )
  {
    return Execute( StringToParameters( ParametersLine ), out );
  }

  /** Esegue il comando rappresentato da una stringa.*/
  public Object Execute( String ParametersLine )
  {
    return Execute( StringToParameters( ParametersLine ) );
  }

  /** Converte una stringa contenente una sequenza di parametri
  * in una Collection di singoli parametri.
  */
  public Collection StringToParameters( String ParametersLine )
  {
    final String StringDelimiters = "\"'`";     // Elenco separatori di stringhe: " ' `
    final String TokenDelimiters = " ";       // Elenco separatori di items: scartati nella lettura
    Collection Parameters = new Vector();

    StringTokenizer stok = new StringTokenizer( ParametersLine, TokenDelimiters + StringDelimiters, true );

    try
    {
      while( stok.hasMoreTokens() )
      {
        String Token = stok.nextToken();

        if( (StringDelimiters.indexOf( Token ) != -1) ) //Se ho uno dei separatori di stringa
        {
          // Salto all'altro separatore
          Parameters.add( stok.nextToken( Token ) );
          //Scarto il token contenente il separatore e resetto l'insiseme dei separatori
          stok.nextToken( TokenDelimiters + StringDelimiters );
        }
        else if( TokenDelimiters.indexOf( Token ) == -1 )  // Scarto gli spazi
          Parameters.add( Token );
      }
    }
    catch( NoSuchElementException  e )
    {}   // Nessun problema: semplicemente  finita la stringa!

    //System.out.println( "Parameters: " + Parameters );
    return Parameters;
  }

  /** Esegue il comando rappresentato da una Collection di parametri, specificando il PrintStream di output.
  *
  * @return Un Object risultato della computazione.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    Iterator ParametersIterator = Parameters.iterator();
    Object ReturnObject = null; // Inizializzato a null!

    // Se c' almeno un parametro: lo eseguo.
    if( ParametersIterator.hasNext() )
    {
      Object KeyParameter = ParametersIterator.next();

      // Cerco il primo parametro nella hashtable.
      ExplorerItem theItem = (ExplorerItem)Items.get( KeyParameter );

      if( theItem == null ) // Non trovato.
      {
        out.println( "> Item " + KeyParameter + " not found." );
      }
      else // Trovato: lo eseguo passandogli gli altri parametri.
      {
        ParametersIterator.remove();       // Tolgo la key.
        //out.print( "." + KeyParameter );   // Mostro il percorso.
        ReturnObject = theItem.Execute( Parameters, out );
      }
    }
    else
    {
      out.println( "> Listing:" );

      PrintDirectory( out );
      ReturnObject = this;
    }

    return ReturnObject;
  }

  /** Aggiunge una voce al menu.
  * @param key oggetto necessario per reperire la voce di menu,
  *   key.toString() contiene la rappresentazione in stringa della voce stessa.
  *   Normalmente l'oggetto key e' semplicemente una stringa che identifica la voce di menu.
  *
  * @param value L'{@link SOMA.explorer.ExplorerItem ExplorerItem} che rappresenta la voce di menu.
  *
  * @return il <code>value</code> precendente, oppure <code>null</code>.
  */
  public ExplorerItem addItem( Object key, ExplorerItem value )
  {
    return addItem( key, value, EndPosition );
  }

  /** Aggiunge una voce al menu in una determinata posizione.
  * @param key oggetto necessario per reperire la voce di menu,
  *   key.toString() contiene la rappresentazione in stringa della voce stessa.
  *   Normalmente l'oggetto key e' semplicemente una stringa che identifica la voce di menu.
  *
  * @param value L'{@link SOMA.explorer.ExplorerItem ExplorerItem} che rappresenta la voce di menu.
  *
  * @param InsertPosition La posizione di inserimento.
  *
  * @return il <code>value</code> precendente, oppure <code>null</code>.
  */
  public ExplorerItem addItem( Object key, ExplorerItem value, int InsertPosition )
  {
    Object ReturnValue = null;

    try
    {
      int DeletePos = Index.indexOf( key );
      if( DeletePos != -1 )
        Index.remove( DeletePos );

      if( InsertPosition != EndPosition )
        Index.add( InsertPosition, key );
      else
        Index.add( key );

      ReturnValue = Items.put( key, value );
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    finally
    {
      return (ExplorerItem)ReturnValue;
    }
  }

  /** Aggiunge un sottomenu al menu.
  * @param value L'{@link SOMA.explorer.ExplorerItem ExplorerItem} che rappresenta il sottomenu.
  *
  * @return il <code>value</code> precendente, oppure <code>null</code>.
  */
  public ExplorerItem addItem( DirExplorerItem value )
  {
    return addItem( value, EndPosition );
  }

  /** Aggiunge un sottomenu al menu in una determinata posizione.
  * @param value L'{@link SOMA.explorer.ExplorerItem ExplorerItem} che rappresenta il sottomenu.
  *
  * @param InsertPosition La posizione di inserimento.
  *
  * @return il <code>value</code> precendente, oppure <code>null</code>.
  */
  public ExplorerItem addItem( DirExplorerItem value, int Position )
  {
    value.addItem( UpperLevelDirectoryString, this, 0 );
    return addItem( value.DirectoryName, value );
  }

  /** Rimuove una voce di menu restituendo il valore precedente. */
  public ExplorerItem removeItem( Object key )
  {
    Object ReturnValue = null;

    try
    {
      int Pos = Index.indexOf( key );
      if( Pos != -1 )
        Index.remove( Pos );

      ReturnValue = Items.remove( key );
    }
    catch( UnsupportedOperationException e )
    {
      e.printStackTrace();
    }
    finally
    {
      return (ExplorerItem)ReturnValue;
    }
  }

  /** Restiutuisce una voce di menu. */
  public ExplorerItem getItem( Collection Parameters )
  {
    Iterator ParametersIterator = Parameters.iterator();
    ExplorerItem ReturnItem = null; // Inizializzato a null!

    // Se c' almeno un parametro: lo eseguo.
    if( ParametersIterator.hasNext() )
    {
      Object KeyParameter = ParametersIterator.next();

      // Cerco il primo parametro nella hashtable.
      ExplorerItem theItem = (ExplorerItem)Items.get( KeyParameter );

      System.out.print( KeyParameter + "->" );

      if( ParametersIterator.hasNext() )
      {
        ParametersIterator.remove();       // Tolgo la key.

        if( theItem instanceof DirExplorerItem )
        {
          ReturnItem = ((DirExplorerItem)theItem).getItem( Parameters );
        }
        // altrimenti il risultato resta null, perche' ho ancora paramentri ma non ho una directory da espolorare.
      }
      else
        ReturnItem = theItem;
    }

    return ReturnItem;
  }

  /** Restiutuisce una voce di menu. */
  public ExplorerItem getItem( Object key )
  {
    Object ReturnValue = null;

    try
    {
      ReturnValue = Items.get( key );
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }
    finally
    {
      return (ExplorerItem)ReturnValue;
    }
  }

  // Qui iniziano i metodi che ho aggiunto
  // Mi servono per accedere a Item e Index che sono dichiarate "private"
  // Mario

  ExplorerItem getItem(int keyindex) {

    return getItem(getKey(keyindex));

  }

  Object getKey(int keyindex) {

    return Index.get(keyindex);

  }

  int getItemNumber() {

    return Index.size();

  }
  // Qui finisce il codice che ho aggiunto
  // Mario

  /** Stampa la lista delle voci del direttorio su un PrintStream.*/
  public void PrintDirectory( PrintStream out )
  {
    //for( Iterator ListingIterator = Items.entrySet().iterator(); ListingIterator.hasNext(); )
    for( Iterator ListingIterator = Index.iterator(); ListingIterator.hasNext(); )
    {
      //Map.Entry anItem = (Map.Entry)ListingIterator.next();
      Object Key = ListingIterator.next();
      ExplorerItem Value = (ExplorerItem)Items.get( Key );

      // Stampa l'etichetta e la sintassi della item
      //out.println( "   " + anItem.getKey() + " " + ((ExplorerItem)anItem.getValue()).Syntax );
      out.println( "   " + Key + " " + Value.getSyntax() );
    }
  }

  // Qui finsicono i metodi che ho aggiunto


  /** Restituisce una stringa che rappresenta il percorso assoluto del direttorio corrente.*/
  public String BuildPath()
  {
    DirExplorerItem UpperLevelDirectory = (DirExplorerItem)Items.get( UpperLevelDirectoryString );

    if( UpperLevelDirectory == null ) // root direcrory.
      return DirectoryName;
    else
      return UpperLevelDirectory.BuildPath() + "/" + DirectoryName;
  }

  /** Restrituisce il direttorio radice.*/
  public DirExplorerItem FindRootDirectory()
  {
    DirExplorerItem UpperLevelDirectory = (DirExplorerItem)Items.get( UpperLevelDirectoryString );

    if( UpperLevelDirectory == null ) // root direcrory.
    {
      //System.out.println( "Root:=========> " + this );
      return this;
    }
    else
      return UpperLevelDirectory.FindRootDirectory();
  }

  /** Restrituisce il direttorio rappresentato da una collezione di parametri.*/
  public DirExplorerItem FindDirectory( Collection Parameters, PrintStream out )
  {
    Iterator ParametersIterator = Parameters.iterator();
    Object ReturnObject = null; // Inizializzato a null!

    // Se c' almeno un parametro: lo eseguo.
    if( ParametersIterator.hasNext() )
    {
      Object KeyParameter = ParametersIterator.next();

      // Cerco il primo parametro nella hashtable.
      ExplorerItem theItem = (ExplorerItem)Items.get( KeyParameter );

      if( theItem instanceof DirExplorerItem  )
      {
        DirExplorerItem theDirItem = (DirExplorerItem)theItem;

        ParametersIterator.remove();       // Tolgo la key.
        out.print( "->" + KeyParameter );   // Mostro il percorso.

        ReturnObject = theDirItem.FindDirectory( Parameters, out );
      }
      else
        out.print( "->" + KeyParameter + ": not found!" );
    }
    else
    {
      ReturnObject = this;
    }

    return (DirExplorerItem)ReturnObject;
  }

  class ChangeDirExplorerItem extends ExplorerItem
  {
    public ChangeDirExplorerItem()
    {
      super( "[/] Directory SubDirectory ..." );
    }

    public String Help( PrintStream out )
    {
      out.println( "cd [/] Directory SubDirectory ..." );
      out.println( "   Change directory to the specified path." );
      out.println( "   Subdirecories are separate by spaces." );
      out.println( "   The root direcrory is / or \\" );

      return Syntax;
    }

    public Object Execute( Collection Parameters, PrintStream out )
    {
      Object ReturnObject = null;


      Iterator ParametersIterator = Parameters.iterator();

      // Se c' almeno un parametro: lo eseguo.
      if( ParametersIterator.hasNext() )
      {
        Object KeyParameter = ParametersIterator.next();
        DirExplorerItem BaseDirectory = DirExplorerItem.this;
        // Occhio: questa sintassi, introdotta ina Java 1.1
        //    fa riferimento alla DirExplorerItem che contiene questo oggetto.

        // Se  una ricerca assoluta = parto dalla root
        if( KeyParameter.equals( "\\" ) || KeyParameter.equals( "/" ) )
        {
          ParametersIterator.remove();
          BaseDirectory = FindRootDirectory();
        }

        DirExplorerItem TargetDir = BaseDirectory.FindDirectory( Parameters, out );

        if( TargetDir != null )
          ReturnObject = new ChangeDirMessage( TargetDir );
        else
          out.println( "Invalid Directory." );
      }
      else
        out.println( "Syntax: cd [/] Directory SubDirectory ..." );

      return ReturnObject;
    }
  }


  class HelpExplorerItem extends ExplorerItem
  {
    public HelpExplorerItem()
    {
      super( "help!" );
    }

    public String Help( PrintStream out )
    {
      out.println( "help item path" );
      out.println( "   Prints the help message for the specified item." );
      out.println( "help" );
      out.println( "   Prints the help message for every item in the current directory." );

      return Syntax;
    }

    public Object Execute( Collection Parameters, PrintStream out )
    {
      Object ReturnObject = null;

      if( Parameters.size() == 0 )
      {
        String Path = BuildPath();

        //for( Iterator ListingIterator = Items.entrySet().iterator(); ListingIterator.hasNext(); )
        for( Iterator ListingIterator = Index.iterator(); ListingIterator.hasNext(); )
        {
          Object Key = ListingIterator.next();
          //Map.Entry anItem = (Map.Entry)ListingIterator.next();

          // Stampa l'etichetta e la sintassi della item
          out.println( Path + "/" + Key + ":" );
          ((ExplorerItem)Items.get( Key )).Help( out );
          //((ExplorerItem)anItem.getValue()).Help( out );
          out.println();
        }
        ReturnObject = Index;
      }
      else
      {
        // C' sicuramente almeno un parametro: lo pesco.
        //Object KeyParameter = Parameters.iterator().next();

        // Cerco il primo parametro nella hashtable.
        ExplorerItem theItem = getItem( Parameters );

        if( theItem == null ) // Non trovato.
          out.println( "> Item " + Parameters + " not found." );
        else
          theItem.Help();

        ReturnObject = theItem;
      }

      return ReturnObject;
    }
  }

  static class ChangeDirMessage
  {
    public DirExplorerItem targetDirectory;

    public ChangeDirMessage( DirExplorerItem targetDirectory )
    {
      this.targetDirectory = targetDirectory;
    }

    public String toString()
    {
      return "Change dir to: " + targetDirectory;
    }
  }
}
