package SOMA.agent.mobility;

import SOMA.network.connection.Command;
import SOMA.agent.Message;
/**
  *  Classe di comando per la spedizione di un messaggio.
  *  <P>Il costruttore richiede come argomento il messaggio ed il numero di
  *  effettuati.
  *
  * @author Livio Profiri
  */
public class SendMessageCommand extends Command
{
  private Message message;
  private int attemptsCount;

  SendMessageCommand( Message message, int attemptsCount )
  {
    this.message = message;
    this.attemptsCount = attemptsCount;
  }

  public void run()
  {
    env.agentManager.sendMessage( message, attemptsCount );
  }

  public String toString()
  {
    return "[SendMessageCommand " + message + " N." + attemptsCount + "]";
  }
}
