package SOMA.agent.classLoading;

/**  Con questo stream scongelo gli agenti che viaggiano congelati ossia
  *  sottoforma di array di byte
  *  viaggiano in quella forma poiche' altrimenti non potrei caricarli
  *  con il classloader che dico io
  */

import java.io.*;
import java.util.*;
import SOMA.agent.Agent;

public class AgentOutputStream extends ObjectOutputStream
{
  // Attenzione: richiedo che il classloader sia un AgentClassLoader:
  //   non accetto che gli agenti siano caricati da un classloader diverso.

  private AgentClassLoader loader = null;
  private Set classToLoadSet = new TreeSet();

  public AgentOutputStream( OutputStream out, Agent agent )
                                           throws IOException
  {
    super(out);

    // Salvo tutte le classi caricate dal classloader dell'agente
    this.loader = (AgentClassLoader)agent.getClass().getClassLoader();
  }

  // Attenzione: prevedo il loading delle sole classi caricate dal classloader dell'agente.
  //   Non voglio che l'agente faccia uso di classi fornite da altri.
  protected void annotateClass( Class cl ) throws IOException
  {
    //System.out.println( "Annotate Class: " + cl.getName() );

    if( loader != null && loader.equals( cl.getClassLoader() ) )
    {
      classToLoadSet.add( cl.getName() );
    }
  }

  public Set getClassToLoadSet()
  {
    return classToLoadSet;
  }
}
