package SOMA.agent;

import java.util.*;
import java.io.Serializable;
/**
  *  Classe di gestione dello scambio dei messaggi.
  *  La Mailbox e' serializzabile e viene creata implicitamente
  *  alla creazione dell'agente (variabile privata Mail).
  * @author        Fabio Tarantino
  * @version            10/12/1997
  */


public class Mailbox implements Serializable
{
  private LinkedList messages = new LinkedList();

  public MailListener mailListener = null;

  public Mailbox()
  {}


/**
  * Metodo implicitamente chiamato dal sistema quando arriva un messaggio
  */
  public synchronized void storeMessage( Message message )
  {
    messages.addLast( message );

    notifyAll();

    if( mailListener != null )
      mailListener.run();
  }

/**
  * Restituisce il primo messaggio in mailbox. La chiamata e' sospensiva
  * ma esiste la possibilita' di verificare se la Maibox e' piena
  */

  public synchronized Message getMessage()
  {
    try
    {
	    while( messages.size() == 0 )
	      wait();
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }

    return (Message)messages.removeFirst();
  }

  /**
    * Verifica se sono presenti messaggi in Mailbox.
    */
  public synchronized boolean isMessage()
  {
    return messages.size() > 0;
  }

  /** Restituisce, fra l'altro, il numero di messaggi.
  */
  public String toString()
  {
    return "[" + messages.size() + " messages]";
  }

  public static interface MailListener extends Serializable
  {
    public void run();
  }
}
