#include "res_ProcessMonitor.h"
#include <wtypes.h>




static int os=-1;   //0=NT, 1=win95


void getOs()
{
OSVERSIONINFO info;
info.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
GetVersionEx(&info);
switch(info.dwPlatformId)
{
case VER_PLATFORM_WIN32_WINDOWS:os=1;break;
case VER_PLATFORM_WIN32_NT:os=0;break;
default:os=2;
}
}







/*
 * Class:     res_ProcessMonitor
 * Method:    getPid
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_res_ProcessMonitor_getPid
  (JNIEnv *env, jobject thiz)
{return GetCurrentProcessId();}







jlong PhysicalMemory()
{
MEMORYSTATUS mem;
GlobalMemoryStatus(&mem);
return mem.dwTotalPhys;
}








PPERF_DATA_BLOCK CollectData(LPTSTR query)
  {
  LPBYTE data;
  DWORD BufferSize=4096;
  data= malloc( BufferSize );

  while(RegQueryValueEx( HKEY_PERFORMANCE_DATA, query, NULL, NULL,
                         data, &BufferSize ) == ERROR_MORE_DATA )
   {
   BufferSize += 4096;
   data= realloc( data, BufferSize );
   }
 
  RegCloseKey(HKEY_PERFORMANCE_DATA);
  return (PPERF_DATA_BLOCK) data;
  }



PPERF_OBJECT_TYPE FindObject( PPERF_DATA_BLOCK perfdata , DWORD index)
{
PPERF_OBJECT_TYPE obj;
DWORD i;
for(i=0,obj= (PPERF_OBJECT_TYPE)((PBYTE)perfdata + perfdata->HeaderLength) ;   //1st
    i<perfdata->NumObjectTypes;
    i++,obj= (PPERF_OBJECT_TYPE)((PBYTE)obj + obj->TotalByteLength) )
 if(obj->ObjectNameTitleIndex==index) return obj;
 return NULL;    
}



void FindCounters(PPERF_OBJECT_TYPE obj, DWORD index[],
                  PPERF_COUNTER_DEFINITION result[], int len)
{
int i,j;
PPERF_COUNTER_DEFINITION cntr;                  
memset(result,0,sizeof(PPERF_COUNTER_DEFINITION)*len);
for(i=0,cntr = (PPERF_COUNTER_DEFINITION) ((PBYTE)obj + obj->HeaderLength);
    i< obj->NumCounters;
    i++,cntr= (PPERF_COUNTER_DEFINITION)((PBYTE)cntr + cntr->ByteLength) )
for(j=0;j<len;j++)
  if(cntr->CounterNameTitleIndex==index[j])
    result[j]=cntr;
}





PPERF_INSTANCE_DEFINITION FirstInstance( PPERF_OBJECT_TYPE obj )
{
    return( (PPERF_INSTANCE_DEFINITION)((PBYTE)obj + 
        obj->DefinitionLength) );
}

PPERF_INSTANCE_DEFINITION NextInstance( 
    PPERF_INSTANCE_DEFINITION inst )
{
    PPERF_COUNTER_BLOCK cntrBlk;

    cntrBlk = (PPERF_COUNTER_BLOCK)((PBYTE)inst + 
        inst->ByteLength);

    return( (PPERF_INSTANCE_DEFINITION)((PBYTE)cntrBlk + 
        cntrBlk->ByteLength) );
}






jlong InstanceData ( PPERF_INSTANCE_DEFINITION perfinst,PPERF_COUNTER_DEFINITION perfcntr)
   {
    PBYTE data;
    
    data=(PBYTE)perfinst +perfinst->ByteLength + //perf_block
         perfcntr->CounterOffset;
   if(perfcntr->CounterSize==4) return (jlong) (*((LONG*)(data)));
   if(perfcntr->CounterSize==8) return *((jlong*)(data));
   return -1;
   } 


jlong ObjectData ( PPERF_OBJECT_TYPE perfobj,PPERF_COUNTER_DEFINITION perfcntr)
   {
    PBYTE data;
    
    data=(PBYTE)perfobj +perfobj->DefinitionLength + //perf_block
         perfcntr->CounterOffset;
   if(perfcntr->CounterSize==4) return (jlong) (*((LONG*)(data)));
   if(perfcntr->CounterSize==8) return *((jlong*)(data));
   return -1;
   } 


jstring InstanceName(JNIEnv* env,PPERF_INSTANCE_DEFINITION perfinst)
  {
  //per qualche motivo NewString non va...
  int i;
  char s[40];
  for(i=0;i<perfinst->NameLength;i++)
    s[i]=*((char*)perfinst+perfinst->NameOffset+i*2);
  return (*env)->NewStringUTF(env,s);
  }                           
  


jobjectArray getThreadInfo(JNIEnv *env,
                           PPERF_DATA_BLOCK perfdata1,
                           PPERF_DATA_BLOCK perfdata2,
                           jint pid,
                           jsize size)
{                           
jobjectArray array;
jclass clazz;
jobject tinfo;
jfieldID fid[3];

PPERF_INSTANCE_DEFINITION inst1,inst2;
PPERF_OBJECT_TYPE obj1,obj2;
PPERF_COUNTER_DEFINITION cntr[3];
DWORD index[]={804,6,784};     //tid, cpu, pid
DWORD i,j;
jlong prev;
jint tid2;
jfloat cpu;


//identificatori di classe e di metodi
clazz=(*env)->FindClass(env,"res/ThreadInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"tid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[2]=(*env)->GetFieldID(env,clazz,"time","J");

//mi posiziono su obj232=thread
obj2 = FindObject( perfdata2 ,232);
obj1 = FindObject( perfdata1 ,232);

//trovo i contatori
FindCounters(obj2,index,cntr,3);

//creo gli oggetti e l'array di dimensione <size>
for(i=0,inst2 = FirstInstance( obj2 );
    i<size;
    inst2 = NextInstance( inst2 ))   //ah ah: non c' i++!
  {
  if(InstanceData(inst2,cntr[2])!=pid) continue;
  tid2=InstanceData(inst2,cntr[0]);
  prev=0;
  for(j=0,inst1 = FirstInstance( obj1 );
      j<obj1->NumInstances;
      j++,inst1 = NextInstance( inst1 ))
    if(tid2==InstanceData(inst1,cntr[0]))
      {
      prev=InstanceData(inst1,cntr[1]);
      break;
      }
  tinfo=(*env)->AllocObject(env,clazz);
  (*env)->SetIntField(env,tinfo,fid[0],tid2);
  cpu=(jfloat)(InstanceData(inst2,cntr[1])-prev)*100/
      (jfloat)(obj2->PerfTime.QuadPart-obj1->PerfTime.QuadPart);
  (*env)->SetFloatField(env,tinfo,fid[1],cpu);
  (*env)->SetLongField(env,tinfo,fid[2],InstanceData(inst2,cntr[1])/10000);
  if(i==0) array=(*env)->NewObjectArray(env, size, clazz, tinfo);
  else (*env)->SetObjectArrayElement(env,array,i,tinfo);
  i++;
  }     
return array;
}








/*
 * Class:     res_ProcessMonitor
 * Method:    getProcessInfo
 * Signature: (J)[Lres/ProcessInfo;
 */
JNIEXPORT jobjectArray JNICALL Java_res_ProcessMonitor_getProcessInfo__J
  (JNIEnv *env, jobject thiz, jlong msec)
{
jobjectArray array;
jclass clazz;
jobject pinfo;
jfieldID fid[8];

PPERF_DATA_BLOCK perfdata1,perfdata2;
PPERF_OBJECT_TYPE obj1,obj2;
PPERF_INSTANCE_DEFINITION inst1,inst2;
PPERF_COUNTER_DEFINITION cntr[5];
DWORD index[]={784,180,174,680,6};   //pid,mem_f,mem_v,#th,cpu
DWORD i,j;
jlong pid2,prev;
jfloat cpu;

//identificatori di classe e di metodi
clazz=(*env)->FindClass(env,"res/ProcessInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"pid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"phys_mem","J");
fid[2]=(*env)->GetFieldID(env,clazz,"virt_mem","J");
fid[3]=(*env)->GetFieldID(env,clazz,"thread","[Lres/ThreadInfo;");
fid[4]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[5]=(*env)->GetFieldID(env,clazz,"time","J");
fid[6]=(*env)->GetFieldID(env,clazz,"name","Ljava/lang/String;");
fid[7]=(*env)->GetStaticFieldID(env,clazz,"total_mem","J");

(*env)->SetStaticLongField(env,clazz,fid[7],PhysicalMemory());
if(os<0) getOs();
if(os!=0)
  return (*env)->NewObjectArray(env,0,clazz,NULL);

perfdata1 = CollectData("230 232");

Sleep(msec);

perfdata2=CollectData("230 232");

//mi posiziono su obj230=process
obj1 = FindObject( perfdata1,230);
obj2 = FindObject( perfdata2 ,230);

//trovo i contatori
FindCounters(obj2,index,cntr,5);


//per ogni istanza creo un oggetto e lo metto nell'array
for(i=0,inst2 = FirstInstance( obj2 );
    i<obj2->NumInstances-1;  //l'ultimo  _Total
    i++,inst2 = NextInstance( inst2 ))
  {
  pid2=InstanceData(inst2,cntr[0]);
  prev=0;
  for(j=0,inst1 = FirstInstance( obj1 );
      j<obj1->NumInstances-1;
      j++,inst1 = NextInstance( inst1 ))
  if(pid2==InstanceData(inst1,cntr[0]))
    {
    prev=InstanceData(inst1,cntr[4]);
    break;
    }
  pinfo=(*env)->AllocObject(env,clazz);
  (*env)->SetIntField(env,pinfo,fid[0],pid2);
  (*env)->SetLongField(env,pinfo,fid[1],InstanceData(inst2,cntr[1]));
  (*env)->SetLongField(env,pinfo,fid[2],InstanceData(inst2,cntr[2]));
  (*env)->SetObjectField(env,pinfo,fid[3],
            getThreadInfo(env,perfdata1,perfdata2,pid2,
                          InstanceData(inst2,cntr[3])));
  cpu=(jfloat)(InstanceData(inst2,cntr[4])-prev)*100/
      (jfloat)(obj2->PerfTime.QuadPart-obj1->PerfTime.QuadPart);
  (*env)->SetFloatField(env,pinfo,fid[4],cpu);
  (*env)->SetLongField(env,pinfo,fid[5],InstanceData(inst2,cntr[4])/10000);
  (*env)->SetObjectField(env,pinfo,fid[6],InstanceName(env,inst2));
  if(i==0) array=(*env)->NewObjectArray(env,(jsize)obj2->NumInstances-1,
                                        clazz, pinfo);
  else (*env)->SetObjectArrayElement(env,array,(jsize)i,pinfo);
  }     
free(perfdata2);
free(perfdata1);
return array;
}









/*
 * Class:     res_ProcessMonitor
 * Method:    getProcessInfo
 * Signature: (IJ)Lres/ProcessInfo;
 */
JNIEXPORT jobject JNICALL Java_res_ProcessMonitor_getProcessInfo__IJ
  (JNIEnv *env, jobject thiz, jint pid, jlong msec)
{
jclass clazz;
jobject pinfo;
jfieldID fid[8];

PPERF_DATA_BLOCK perfdata1,perfdata2;
PPERF_OBJECT_TYPE obj1,obj2;
PPERF_INSTANCE_DEFINITION inst1,inst2;
PPERF_COUNTER_DEFINITION cntr[5];
DWORD index[]={784,180,174,680,6};   //pid,mem_f,mem_v,#th,cpu
DWORD i,j;
jlong prev;
jfloat cpu;

//identificatori di classe e di metodi
clazz=(*env)->FindClass(env,"res/ProcessInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"pid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"phys_mem","J");
fid[2]=(*env)->GetFieldID(env,clazz,"virt_mem","J");
fid[3]=(*env)->GetFieldID(env,clazz,"thread","[Lres/ThreadInfo;");
fid[4]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[5]=(*env)->GetFieldID(env,clazz,"time","J");
fid[6]=(*env)->GetFieldID(env,clazz,"name","Ljava/lang/String;");
fid[7]=(*env)->GetStaticFieldID(env,clazz,"total_mem","J");

(*env)->SetStaticLongField(env,clazz,fid[7],PhysicalMemory());
if(os<0) getOs();
if(os!=0)
  {
  clazz=(*env)->FindClass(env,"java/lang/Exception");
  (*env)->ThrowNew(env,clazz,"Process not found");
  //non dovrei mai essere qui...
  return NULL;
  }

perfdata1 = CollectData("230 232");

Sleep(msec);

perfdata2=CollectData("230 232");

//mi posiziono su obj230=process
obj1 = FindObject( perfdata1 ,230);
obj2 = FindObject( perfdata2 ,230);

//trovo i contatori
FindCounters(obj2,index,cntr,5);


//cerco l'istanza con pid
prev=0;
for(i=0,inst2 = FirstInstance( obj2 );
    i<obj2->NumInstances-1;
    i++,inst2 = NextInstance( inst2 ))
if(InstanceData(inst2,cntr[0])==pid)
  {
  for(j=0,inst1 = FirstInstance( obj1 );
      j<obj1->NumInstances-1;
      j++,inst1 = NextInstance( inst1 ))
  if(InstanceData(inst1,cntr[0])==pid)
    {
    prev=InstanceData(inst1,cntr[4]);
    break;
    }
  pinfo=(*env)->AllocObject(env,clazz);
  (*env)->SetIntField(env,pinfo,fid[0],pid);
  (*env)->SetLongField(env,pinfo,fid[1],InstanceData(inst2,cntr[1]));
  (*env)->SetLongField(env,pinfo,fid[2],InstanceData(inst2,cntr[2]));
  (*env)->SetObjectField(env,pinfo,fid[3],
          getThreadInfo(env,perfdata1,perfdata2,pid,
                        InstanceData(inst2,cntr[3])));
  cpu=(jfloat)(InstanceData(inst2,cntr[4])-prev)*100/
      (jfloat)(obj2->PerfTime.QuadPart-obj1->PerfTime.QuadPart);
  (*env)->SetFloatField(env,pinfo,fid[4],cpu);
  (*env)->SetLongField(env,pinfo,fid[5],InstanceData(inst2,cntr[4])/10000);
  (*env)->SetObjectField(env,pinfo,fid[6],InstanceName(env,inst2));
  free(perfdata2);
  free(perfdata1);
  return pinfo;
  }     

//se sono qui non esiste un'istanza con pid
free(perfdata2);
free(perfdata1);
clazz=(*env)->FindClass(env,"java/lang/Exception");
(*env)->ThrowNew(env,clazz,"Process not found");
//non dovrei mai essere qui...
return NULL;
}


