/*
 * Decompiled with CFR 0.152.
 */
package SOMA.telnet;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.ExplorerThread;
import SOMA.network.connection.Connection;
import SOMA.network.connection.QuickCommand;
import SOMA.output.OutputFrame;
import SOMA.output.Pipetta;
import java.awt.Color;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;

public class TelnetExplorerItem
extends ExplorerItem {
    public TelnetExplorerItem() {
        super("<host> <port>");
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        block4: {
            if (collection.size() != 2) break block4;
            Iterator iterator = collection.iterator();
            String string = (String)iterator.next();
            String string2 = (String)iterator.next();
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                printStream.println("ERROR: incorrect port number" + string2);
                return null;
            }
            try {
                final OutputFrame outputFrame = new OutputFrame("Telnet: " + string + " " + n);
                outputFrame.ListOut.Target.setBackground(new Color(0xC0C0C0));
                final Connection connection = new Connection(new Socket(string, n), null);
                outputFrame.OnExitCommand = new OutputFrame.Listener(){

                    public void run() {
                        outputFrame.out.println("  Exiting!");
                        outputFrame.setVisible(false);
                        outputFrame.dispose();
                        try {
                            connection.stop();
                        }
                        catch (Exception exception) {}
                    }
                };
                connection.send(new QuickCommand(){

                    public void run() {
                        ExplorerThread explorerThread = new ExplorerThread(this.env.dir, this.ReturnConnection.getIn(), this.env.out, true);
                        explorerThread.start();
                        this.env.multiOut.add(this.ReturnConnection.getOut());
                        this.env.out.println();
                        this.env.out.println("Connection " + this.ReturnConnection + " used for telnet!!!");
                        this.env.out.println();
                        try {
                            explorerThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace(this.env.out);
                        }
                    }
                });
                new Pipetta(outputFrame.in, connection.getOut()).start();
                new Pipetta(connection.getIn(), outputFrame.out).start();
                outputFrame.show();
                outputFrame.toFront();
                printStream.println("Amministrazione avviata!");
            }
            catch (Exception exception) {
                exception.printStackTrace(printStream);
            }
        }
        return null;
    }
}

