/*
 * Decompiled with CFR 0.152.
 */
package SOMA.output;

import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TextFieldInputStream
extends InputStream
implements Serializable {
    private TextField Source;
    private transient ByteArrayInputStream In;
    private String InputBuffer = "";
    private static final String LineSeparator = System.getProperty("line.separator");

    public TextFieldInputStream(TextField textField) {
        this.Source = textField;
        this.In = new ByteArrayInputStream(new byte[0]);
        SourceListener sourceListener = new SourceListener();
        textField.addActionListener(sourceListener);
    }

    private synchronized void PrepareIn() {
        if (this.InputBuffer.equals("")) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        } else {
            try {
                this.In.close();
            }
            catch (IOException iOException) {}
            this.In = new ByteArrayInputStream(this.InputBuffer.getBytes());
            this.InputBuffer = "";
        }
    }

    public int available() throws IOException {
        return this.In.available();
    }

    public synchronized int read() throws IOException {
        while (this.In.available() == 0) {
            this.PrepareIn();
        }
        int n = this.In.read();
        this.notifyAll();
        return n;
    }

    public synchronized int read(byte[] byArray) throws IOException {
        while (this.In.available() == 0) {
            this.PrepareIn();
        }
        int n = this.In.read(byArray);
        this.notifyAll();
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        while (this.In.available() == 0) {
            this.PrepareIn();
        }
        int n3 = this.In.read(byArray, n, n2);
        this.notifyAll();
        return n3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.In = new ByteArrayInputStream(new byte[0]);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = new byte[this.In.available()];
        this.In.read(byArray);
        this.InputBuffer = String.valueOf(new String(byArray)) + this.InputBuffer;
        objectOutputStream.defaultWriteObject();
    }

    class SourceListener
    implements ActionListener,
    Serializable {
        SourceListener() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            TextFieldInputStream textFieldInputStream = TextFieldInputStream.this;
            synchronized (textFieldInputStream) {
                TextFieldInputStream.this.InputBuffer = String.valueOf(TextFieldInputStream.this.InputBuffer) + TextFieldInputStream.this.Source.getText() + LineSeparator;
                TextFieldInputStream.this.notifyAll();
                TextFieldInputStream.this.Source.setText("");
            }
        }
    }
}

