/*
 * Decompiled with CFR 0.152.
 */
package SOMA.output;

import SOMA.Environment;
import SOMA.explorer.LoadScriptActionListener;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.naming.PlaceID;
import SOMA.network.connection.Daemon;
import SOMA.output.OutputFrame;
import java.awt.Color;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JFileChooser;

public class PlaceWindow
implements Daemon {
    Environment env;
    OutputFrame window = null;
    InputStream oldIn = null;
    OutputStream oldOut = null;
    OutputStream oldErr = null;
    Object status = Daemon.OFF;

    public PlaceWindow(Environment environment) {
        this.env = environment;
    }

    public Object getStatus() {
        return this.status;
    }

    public void start() {
        if (this.status == Daemon.OFF) {
            this.oldIn = this.env.in;
            this.oldOut = this.env.multiOut.getFirst();
            this.oldErr = this.env.multiErr.getFirst();
            this.window = new OutputFrame(this.env.placeID.toString());
            this.window.ListOut.Target.setBackground(new Color(0xC0C0C0));
            MenuItem menuItem = new MenuItem("Load script file...");
            menuItem.addActionListener(new LoadScriptActionListener(this.window, "Load script", this.env.dir, this.env.out));
            this.window.menu1.insert(menuItem, 0);
            MenuItem menuItem2 = new MenuItem("Agent CLASSPATH...");
            menuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    File file = new File(PlaceWindow.this.env.agentManager.agentClassManager.getClassPathDirectory());
                    jFileChooser.setCurrentDirectory(file);
                    jFileChooser.changeToParentDirectory();
                    jFileChooser.setSelectedFile(file);
                    jFileChooser.setDialogTitle("Agent CLASSPATH...");
                    if (jFileChooser.showOpenDialog(PlaceWindow.this.window) == 0) {
                        PlaceWindow.this.env.dir.Execute("agentManager path " + jFileChooser.getSelectedFile().getAbsolutePath(), PlaceWindow.this.env.out);
                    }
                }
            });
            MenuItem menuItem3 = new MenuItem("Agent cache...");
            menuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    File file = new File(PlaceWindow.this.env.agentManager.cacheClassManager.getClassPathDirectory());
                    jFileChooser.setCurrentDirectory(file);
                    jFileChooser.changeToParentDirectory();
                    jFileChooser.setSelectedFile(file);
                    jFileChooser.setDialogTitle("Agent cache directory");
                    if (jFileChooser.showOpenDialog(PlaceWindow.this.window) == 0) {
                        PlaceWindow.this.env.dir.Execute("agentManager cache " + jFileChooser.getSelectedFile().getAbsolutePath(), PlaceWindow.this.env.out);
                    }
                }
            });
            this.window.menu1.insert(menuItem2, 1);
            this.window.menu1.insert(menuItem3, 2);
            this.window.menu1.insertSeparator(3);
            MenuItem menuItem4 = new MenuItem("Launch Agent...", new MenuShortcut(76));
            menuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PlaceWindow.this.window.out.println("Insert: <agent_class_name> <parameters>:");
                    new Thread(PlaceWindow.this, String.valueOf(PlaceWindow.this.env.placeID.toString()) + "Place Window: launch agent"){
                        private final /* synthetic */ PlaceWindow this$0;
                        {
                            this.this$0 = placeWindow;
                        }

                        public void run() {
                            try {
                                this.this$0.env.dir.Execute("agentManager launch " + this.this$0.window.inBufferedReader.readLine(), this.this$0.window.out);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace(this.this$0.window.out);
                            }
                        }
                    }.start();
                }
            });
            this.window.menu1.insert(menuItem4, 0);
            this.window.menu1.insertSeparator(1);
            if (this.env.placeID instanceof MobilePlaceID) {
                MenuItem menuItem5 = new MenuItem("Connect to domain...", new MenuShortcut(67));
                menuItem5.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        PlaceWindow.this.window.out.println("Insert <domain name>:");
                        new Thread(PlaceWindow.this, String.valueOf(PlaceWindow.this.env.placeID.toString()) + "Place Window: connect to..."){
                            private final /* synthetic */ PlaceWindow this$0;
                            {
                                this.this$0 = placeWindow;
                            }

                            public void run() {
                                try {
                                    this.this$0.env.dir.Execute("connect " + this.this$0.window.inBufferedReader.readLine(), this.this$0.window.out);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(this.this$0.window.out);
                                }
                            }
                        }.start();
                    }
                });
                MenuItem menuItem6 = new MenuItem("Disconnect", new MenuShortcut(68));
                menuItem6.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        new Thread(PlaceWindow.this, String.valueOf(PlaceWindow.this.env.placeID.toString()) + "Place Window: disconnect"){
                            private final /* synthetic */ PlaceWindow this$0;
                            {
                                this.this$0 = placeWindow;
                            }

                            public void run() {
                                try {
                                    this.this$0.env.dir.Execute("disconnect", this.this$0.window.out);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace(this.this$0.window.out);
                                }
                            }
                        }.start();
                    }
                });
                MenuItem menuItem7 = new MenuItem("Status");
                menuItem7.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            PlaceID placeID = (PlaceID)PlaceWindow.this.env.dir.Execute("currentDomain", PlaceWindow.this.window.out);
                            PlaceWindow.this.window.out.println();
                            if (placeID == MobilePlaceManager.DISCONNECTED) {
                                PlaceWindow.this.window.out.println("The mobile place is disconnected");
                            } else {
                                PlaceWindow.this.window.out.println("The mobile place is connected to " + placeID);
                            }
                            PlaceWindow.this.window.out.println();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(PlaceWindow.this.window.out);
                        }
                    }
                });
                this.window.menu1.insert(menuItem5, 2);
                this.window.menu1.insert(menuItem6, 3);
                this.window.menu1.insert(menuItem7, 4);
                this.window.menu1.insertSeparator(5);
            }
            this.window.OnExitCommand = new OutputFrame.Listener(){

                public void run() {
                    PlaceWindow.this.window.out.println("  Exiting!");
                    PlaceWindow.this.env.dir.Execute("window stop", PlaceWindow.this.window.out);
                }
            };
            this.env.in = this.window.in;
            this.env.multiOut.setFirst(this.window.out);
            this.env.multiErr.setFirst(this.window.out);
            this.window.show();
            this.window.toFront();
            this.status = Daemon.ON;
        } else {
            this.env.out.println("Window already " + this.status);
        }
    }

    public void stop() {
        if (this.status == Daemon.ON) {
            this.env.in = this.oldIn;
            this.env.multiOut.setFirst(this.oldOut);
            this.env.multiErr.setFirst(this.oldErr);
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
            this.status = Daemon.OFF;
        } else {
            this.env.out.println("Window already " + this.status);
        }
    }

    public String toString() {
        return "[PlaceWindow " + this.status + "]";
    }
}

