/*
 * Decompiled with CFR 0.152.
 */
package SOMA.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class JTextAreaOutputStream
extends OutputStream
implements Serializable {
    public JTextArea Target;
    public JScrollBar jScrollBar;
    private int MaxLines = 500;
    private static final String LineSeparator = System.getProperty("line.separator");

    public JTextAreaOutputStream(JTextArea jTextArea, JScrollBar jScrollBar) {
        this.Target = jTextArea;
        this.jScrollBar = jScrollBar;
        jTextArea.append("");
    }

    public JTextAreaOutputStream(JTextArea jTextArea, JScrollBar jScrollBar, int n) {
        this(jTextArea, jScrollBar);
        this.MaxLines = n;
    }

    private void WriteString(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Target.append(string);
                int n = Target.getLineCount();
                if (n > MaxLines) {
                    try {
                        Target.replaceRange("", 0, Target.getLineEndOffset(n - MaxLines));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (!jScrollBar.getValueIsAdjusting()) {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
                return null;
            }
        });
    }

    public void write(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(n);
        this.WriteString(byteArrayOutputStream.toString());
        byteArrayOutputStream.close();
    }

    public void write(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        this.WriteString(byteArrayOutputStream.toString());
        byteArrayOutputStream.close();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray, n, n2);
        this.WriteString(byteArrayOutputStream.toString());
        byteArrayOutputStream.close();
    }
}

