/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network.connection;

import SOMA.Environment;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import SOMA.network.connection.ConnectionServer;
import SOMA.network.connection.DaemonExplorerItem;
import SOMA.network.connection.ExplorableConnectionFactory;
import java.io.PrintStream;
import java.util.Collection;

public class NewServerExplorerItem
extends ExplorerItem {
    Environment env;
    DirExplorerItem dir;

    public NewServerExplorerItem(DirExplorerItem dirExplorerItem) {
        super("port");
        this.dir = dirExplorerItem;
        this.env = new Environment(dirExplorerItem, System.in, System.out, System.err);
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        if (collection.size() == 1) {
            String string = (String)collection.iterator().next();
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                printStream.println("ERROR: incorrect port number" + string);
                return null;
            }
            String string2 = "Server" + n;
            DaemonExplorerItem daemonExplorerItem = new DaemonExplorerItem(new ConnectionServer(n, 50, new ExplorableConnectionFactory(this.env, this.dir, String.valueOf(string2) + "_")));
            this.dir.addItem(string2, daemonExplorerItem);
            return daemonExplorerItem;
        }
        return null;
    }

    public String Help(PrintStream printStream) {
        String string = "port: Creates a new server on the specified port.";
        printStream.println(string);
        return string;
    }
}

