/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network.connection;

import SOMA.explorer.ExplorerItem;
import SOMA.network.connection.Daemon;
import java.io.PrintStream;
import java.util.Collection;

public class DaemonExplorerItem
extends ExplorerItem {
    public Daemon daemon;

    public DaemonExplorerItem(Daemon daemon) {
        super("{start | stop | status}");
        this.daemon = daemon;
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        if (collection.size() == 0) {
            printStream.println(this.daemon.toString());
        } else {
            String string = (String)collection.iterator().next();
            if (string.equals("start")) {
                try {
                    this.daemon.start();
                    printStream.println("Started-->" + this.daemon);
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            } else if (string.equals("stop")) {
                try {
                    this.daemon.stop();
                    printStream.println("Stopped-->" + this.daemon);
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            } else if (string.equals("status")) {
                printStream.println("Status: " + this.getStatusString());
            } else {
                printStream.println("Unknown operation: " + string);
            }
        }
        return this.daemon;
    }

    public String Help(PrintStream printStream) {
        printStream.println("  start: starts the daemon.");
        printStream.println("  stop: stops the daemon.");
        printStream.println("  status: returns the daemon's status.");
        return this.daemon.toString();
    }

    public String getStatusString() {
        return this.daemon.getStatus().toString();
    }

    public String getSyntax() {
        return String.valueOf(this.Syntax) + "  (Status " + this.getStatusString() + ")";
    }
}

