/*
 * Decompiled with CFR 0.152.
 */
package SOMA.network.connection;

import SOMA.network.connection.Connection;
import SOMA.network.connection.ConnectionFactory;
import SOMA.network.connection.Daemon;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ConnectionServer
implements Runnable,
Daemon {
    Thread myServerDaemon = null;
    ServerSocket myServerSocket = null;
    ConnectionFactory myConnectionFactory = null;
    Object status = Daemon.OFF;
    String ErrorDescription = "";
    int port = 0;
    int backlog = 50;

    public ConnectionServer(int n, int n2, ConnectionFactory connectionFactory) {
        this.port = n;
        this.backlog = n2;
        this.myConnectionFactory = connectionFactory;
    }

    public Object getStatus() {
        return this.status;
    }

    public void run() {
        Socket socket = null;
        Connection connection = null;
        while (this.status == Daemon.ON) {
            try {
                socket = this.myServerSocket.accept();
                connection = this.myConnectionFactory.createConnection(socket);
                connection.start();
            }
            catch (Exception exception) {
                if (this.status == Daemon.OFF) continue;
                this.status = Daemon.ERROR;
                this.ErrorDescription = exception.toString();
            }
        }
    }

    public synchronized void start() throws IOException, ConnectionServerException {
        if (this.status != Daemon.ON) {
            try {
                this.myServerSocket = new ServerSocket(this.port, this.backlog);
                this.myServerDaemon = new Thread((Runnable)this, this.toString());
                this.status = Daemon.ON;
                this.myServerDaemon.start();
            }
            catch (IOException iOException) {
                this.status = Daemon.ERROR;
                this.ErrorDescription = iOException.toString();
                throw iOException;
            }
        } else {
            throw new ConnectionServerException("Server already ON");
        }
    }

    public synchronized void stop() throws IOException, ConnectionServerException {
        if (this.status != Daemon.OFF) {
            try {
                this.status = Daemon.OFF;
                if (this.myServerSocket != null) {
                    this.myServerSocket.close();
                }
                this.myServerSocket = null;
            }
            catch (IOException iOException) {
                this.status = Daemon.ERROR;
                this.ErrorDescription = iOException.toString();
                throw iOException;
            }
        } else {
            throw new ConnectionServerException("The server is already OFF");
        }
    }

    public String toString() {
        return "[ConnectionServer: socket " + this.myServerSocket + " status: " + this.status + (this.status == Daemon.ERROR ? " " + this.ErrorDescription : "") + "]";
    }

    public static class ConnectionServerException
    extends Exception {
        public ConnectionServerException(String string) {
            super(string);
        }
    }
}

