/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.place;

import SOMA.naming.place.PlaceInfo;
import SOMA.naming.place.PlaceRefreshCommand;
import SOMA.network.connection.Command;

public class PlaceRegisterCommand
extends Command {
    protected PlaceInfo myPlaceInfo;

    public PlaceRegisterCommand(PlaceInfo placeInfo) {
        this.myPlaceInfo = placeInfo;
        System.out.println("Register command " + placeInfo + " created ");
    }

    public void run() {
        this.env.out.println("Register command " + this.myPlaceInfo + " running ");
        if (this.myPlaceInfo.placeID.sameDomain(this.env.placeID) && this.env.placeNameService.getPlace(this.myPlaceInfo.placeID) == null) {
            this.env.placeNameService.putPlace(this.myPlaceInfo);
            this.env.networkManager.connectionStore.putConnection(this.myPlaceInfo.placeID, this.ReturnConnection);
            this.Return(new PlaceRefreshCommand(this.env));
        } else {
            this.Return(new Command(){

                public void run() {
                    this.env.err.println("ERROR: Can't register place " + PlaceRegisterCommand.this.myPlaceInfo);
                    try {
                        this.ReturnConnection.stop();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(this.env.err);
                    }
                }
            });
            this.env.err.println("ERROR: Place " + this.myPlaceInfo + " already exists!");
        }
    }
}

