/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.place;

import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.naming.place.PlaceInfo;
import SOMA.naming.place.PlaceRefreshCommand;
import SOMA.naming.place.PlaceRegisterCommand;
import SOMA.naming.place.PutPlaceCommand;
import SOMA.naming.place.RemovePlaceCommand;
import SOMA.network.connection.Command;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

public class PlaceNameService
implements Serializable {
    protected transient Environment env;
    protected Hashtable places = new Hashtable();

    public PlaceNameService(Environment environment) {
        this.env = environment;
    }

    public synchronized PlaceInfo getPlace(PlaceID placeID) {
        return (PlaceInfo)this.places.get(placeID);
    }

    public PlaceID[] getPlacesArray() {
        return this.places.keySet().toArray(new PlaceID[this.places.size()]);
    }

    public void listPlaces(PrintStream printStream) {
        printStream.println("I know " + this.places.size() + " places:");
        printStream.println();
        int n = 1;
        Enumeration enumeration = this.places.elements();
        while (enumeration.hasMoreElements()) {
            printStream.println("    " + n++ + ") " + enumeration.nextElement().toString());
        }
        printStream.println();
    }

    public synchronized PlaceInfo putPlace(PlaceInfo placeInfo) {
        PlaceInfo placeInfo2 = this.places.put(placeInfo.placeID, placeInfo);
        if (this.env.placeID.isDomain() && !placeInfo.equals(placeInfo2)) {
            this.sendToAllPlaces(new PutPlaceCommand(placeInfo), placeInfo.placeID);
        }
        return placeInfo2;
    }

    public boolean refresh() {
        if (this.env.placeID.isDomain()) {
            this.env.err.println("Can't refresh a default place!");
            return false;
        }
        return this.env.networkManager.sendCommand(this.env.placeID.getDomainID(), new PlaceRefreshCommand.Request());
    }

    public boolean refresh(InetAddress inetAddress, int n) {
        return this.env.networkManager.sendCommand(inetAddress, n, new PlaceRefreshCommand.Request());
    }

    public boolean register(InetAddress inetAddress, int n) {
        return this.env.networkManager.sendCommand(inetAddress, n, new PlaceRegisterCommand(this.env.networkManager.placeInfo));
    }

    public synchronized PlaceInfo removePlace(PlaceID placeID) {
        PlaceInfo placeInfo = (PlaceInfo)this.places.remove(placeID);
        this.env.networkManager.connectionStore.removeConnection(placeID);
        if (this.env.placeID.isDomain() && placeInfo != null) {
            this.sendToAllPlaces(new RemovePlaceCommand(placeID));
        }
        return placeInfo;
    }

    public void sendToAllPlaces(Command command) {
        this.sendToAllPlaces(command, null);
    }

    public void sendToAllPlaces(Command command, PlaceID placeID) {
        this.env.out.println("  Sending " + command + " to every place in my domain:");
        this.env.out.println();
        Enumeration enumeration = this.places.elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            PlaceInfo placeInfo = (PlaceInfo)enumeration.nextElement();
            if (this.env.placeID.equals(placeInfo.placeID)) {
                this.env.err.println("Skipping " + placeInfo);
                continue;
            }
            if (placeInfo.placeID.equals(placeID)) {
                this.env.err.println("Skipping " + placeInfo);
                continue;
            }
            this.env.out.println("    " + n++ + ") " + placeInfo + " result: " + this.env.networkManager.sendCommand(placeInfo.placeID, command));
        }
        this.env.out.println();
    }

    public void setEnv(Environment environment) {
        if (this.env == null) {
            this.env = environment;
        }
    }

    public String toString() {
        return "[pns: " + this.places.size() + " places]";
    }
}

