/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming.domain;

import SOMA.Environment;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DomainInfo;
import SOMA.naming.domain.DomainRefreshCommand;
import SOMA.naming.domain.DomainRegisterCommand;
import SOMA.naming.domain.PutDomainCommand;
import SOMA.naming.domain.RemoveDomainCommand;
import SOMA.network.connection.Command;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class DomainNameService
implements Serializable {
    transient Environment env;
    Hashtable domains = new Hashtable();
    PlaceID fatherDNS = null;
    Set childrenDNS = Collections.synchronizedSet(new HashSet());

    public DomainNameService(Environment environment) {
        this.env = environment;
    }

    public synchronized DomainInfo getDomain(PlaceID placeID) {
        return (DomainInfo)this.domains.get(placeID);
    }

    public PlaceID[] getDomainsArray() {
        return this.domains.keySet().toArray(new PlaceID[this.domains.size()]);
    }

    public void listDomains(PrintStream printStream) {
        printStream.println("I know " + this.domains.size() + " domains:");
        printStream.println();
        int n = 1;
        Enumeration enumeration = this.domains.elements();
        while (enumeration.hasMoreElements()) {
            printStream.println("    " + n++ + ") " + enumeration.nextElement().toString());
        }
        printStream.println();
        if (this.fatherDNS != null) {
            printStream.println("  My father Domain Name Server is " + this.fatherDNS);
        }
        if (this.childrenDNS.size() > 0) {
            printStream.println("  I have " + this.childrenDNS.size() + " children Domain Name Servers:");
            printStream.println();
            n = 1;
            Iterator iterator = this.childrenDNS.iterator();
            while (iterator.hasNext()) {
                printStream.println("    " + n++ + ") " + iterator.next().toString());
            }
            printStream.println();
        }
    }

    public synchronized DomainInfo putDomain(DomainInfo domainInfo) {
        DomainInfo domainInfo2 = this.domains.put(domainInfo.placeID, domainInfo);
        if (!domainInfo.equals(domainInfo2)) {
            this.sendToAllDomains(new PutDomainCommand(domainInfo));
        }
        return domainInfo2;
    }

    public boolean refresh() {
        boolean bl = false;
        DomainInfo domainInfo = this.getDomain(this.fatherDNS);
        if (domainInfo != null) {
            bl = this.refresh(domainInfo.host, domainInfo.port);
        }
        return bl;
    }

    public boolean refresh(InetAddress inetAddress, int n) {
        return this.env.networkManager.sendCommand(inetAddress, n, new DomainRefreshCommand.Request(true));
    }

    public boolean register(InetAddress inetAddress, int n) {
        return this.env.networkManager.sendCommand(inetAddress, n, new DomainRegisterCommand((DomainInfo)this.env.networkManager.placeInfo));
    }

    public synchronized DomainInfo removeDomain(PlaceID placeID) {
        DomainInfo domainInfo = (DomainInfo)this.domains.remove(placeID);
        this.childrenDNS.remove(placeID);
        if (placeID.equals(this.fatherDNS)) {
            this.fatherDNS = null;
        }
        if (domainInfo != null) {
            this.sendToAllDomains(new RemoveDomainCommand(placeID));
        }
        return domainInfo;
    }

    public void sendToAllDomains(Command command) {
        this.sendToFatherDomain(command);
        this.sendToChildrenDomains(command);
    }

    public void sendToChildrenDomains(Command command) {
        if (this.childrenDNS.size() > 0) {
            this.env.out.println("  Sending " + command + " to " + this.childrenDNS.size() + " children DNSs:");
            this.env.out.println();
            int n = 1;
            Iterator iterator = this.childrenDNS.iterator();
            while (iterator.hasNext()) {
                PlaceID placeID = (PlaceID)iterator.next();
                this.env.out.println("    " + n++ + ") " + placeID + " result: " + this.env.networkManager.sendCommand(placeID, command));
            }
            this.env.out.println();
        }
    }

    public boolean sendToFatherDomain(Command command) {
        boolean bl = false;
        if (this.fatherDNS != null) {
            bl = this.env.networkManager.sendCommand(this.fatherDNS, command);
            this.env.out.println("  Sending command " + command + " to father " + this.fatherDNS + " result: " + bl);
            this.env.out.println();
        }
        return bl;
    }

    public void setEnv(Environment environment) {
        if (this.env == null) {
            this.env = environment;
        }
    }

    public String toString() {
        return "[dns: " + this.domains.size() + " domains]";
    }
}

