/*
 * Decompiled with CFR 0.152.
 */
package SOMA.naming;

import SOMA.naming.NameException;
import java.io.Serializable;
import java.util.StringTokenizer;

public class PlaceID
implements Serializable {
    public final String domain;
    public final String place;

    public PlaceID(String string) throws NameException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NameException("Empty Place Name string");
        }
        this.domain = stringTokenizer.nextToken();
        this.place = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        if (stringTokenizer.hasMoreTokens()) {
            throw new NameException("Place Name has more than two tokens");
        }
    }

    public PlaceID(String string, String string2) {
        this.domain = string;
        this.place = string2;
    }

    public Object clone() {
        return new PlaceID(this.domain, this.place);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PlaceID)) {
            return false;
        }
        PlaceID placeID = (PlaceID)object;
        return this.domain.equals(placeID.domain) && this.place.equals(placeID.place);
    }

    public PlaceID getDomainID() {
        return new PlaceID(this.domain, "");
    }

    public PlaceID getHome() {
        return this;
    }

    public int hashCode() {
        return (String.valueOf(this.domain) + this.place).hashCode();
    }

    public boolean isDomain() {
        return this.place.equals("");
    }

    public boolean sameDomain(PlaceID placeID) {
        return this.domain.equals(placeID.domain);
    }

    public String toString() {
        return String.valueOf(this.domain) + " " + this.place;
    }
}

