/*
 * Decompiled with CFR 0.152.
 */
package SOMA.mobilePlace;

import SOMA.mobilePlace.MobileEnvironment;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.naming.PlaceID;
import SOMA.naming.place.PlaceInfo;
import SOMA.naming.place.PlaceRefreshCommand;
import SOMA.network.connection.Command;
import SOMA.network.connection.QuickCommand;

public class MobilePlaceConnectionCommand
extends Command {
    PlaceInfo myPlaceInfo;

    public MobilePlaceConnectionCommand(PlaceInfo placeInfo) {
        this.myPlaceInfo = placeInfo;
    }

    public void run() {
        this.env.placeNameService.putPlace(this.myPlaceInfo);
        PlaceID placeID = this.myPlaceInfo.placeID;
        PlaceID placeID2 = ((MobilePlaceID)placeID).getHome();
        this.env.networkManager.connectionStore.putConnection(placeID, this.ReturnConnection);
        this.env.networkManager.sendCommand(placeID, new PlaceRefreshCommand(this.env));
        this.env.networkManager.sendCommand(placeID, new UpdateMobilePlacePositionCommand(this.env.placeID));
        this.env.networkManager.sendCommand(placeID2, new UpdateHomePositionCommand(placeID, this.env.placeID));
    }

    public static class UpdateHomePositionCommand
    extends Command {
        PlaceID mobilePlaceID;
        PlaceID actualDomainID;

        UpdateHomePositionCommand(PlaceID placeID, PlaceID placeID2) {
            this.mobilePlaceID = placeID;
            this.actualDomainID = placeID2;
        }

        public void run() {
            this.env.mobilePlaceManager.putPosition(this.mobilePlaceID, this.actualDomainID);
            this.env.out.println("HOME - Mobile Place: " + this.mobilePlaceID + " joined domain: " + this.actualDomainID);
            if (!this.actualDomainID.equals(MobilePlaceManager.DISCONNECTED)) {
                this.env.mobilePlaceManager.sendWaitingAgents(this.mobilePlaceID);
            }
        }
    }

    public static class UpdateMobilePlacePositionCommand
    extends QuickCommand {
        PlaceID actualDomainID;

        UpdateMobilePlacePositionCommand(PlaceID placeID) {
            this.actualDomainID = placeID;
        }

        public void run() {
            ((MobileEnvironment)this.env).currentDomainID = this.actualDomainID;
            this.env.out.println("Mobile Place: " + this.env.placeID + " joined domain: " + this.actualDomainID);
        }
    }
}

