/*
 * Decompiled with CFR 0.152.
 */
package SOMA.explorer;

import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;

public class ExplorerThread
extends Thread {
    PrintStream out;
    BufferedReader brIn;
    boolean Continue = true;
    DirExplorerItem Dir;
    DirExplorerItem RootDir;
    boolean echo = false;

    public ExplorerThread(DirExplorerItem dirExplorerItem) {
        this(dirExplorerItem, System.in, System.out, false);
    }

    public ExplorerThread(DirExplorerItem dirExplorerItem, InputStream inputStream, PrintStream printStream, boolean bl) {
        this(Thread.currentThread().getThreadGroup(), dirExplorerItem, inputStream, printStream, bl);
    }

    public ExplorerThread(ThreadGroup threadGroup, DirExplorerItem dirExplorerItem, InputStream inputStream, PrintStream printStream, boolean bl) {
        super(threadGroup, "Explorer Thread");
        this.RootDir = this.Dir = dirExplorerItem;
        this.out = printStream;
        this.echo = bl;
        this.brIn = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void Stop() {
        try {
            this.brIn.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.out);
        }
        this.Continue = false;
    }

    public void addExit() {
        this.RootDir.addItem("exit", new ExplorerItem("Terminates the explorer thread"){

            public Object Execute(Collection collection, PrintStream printStream) {
                ExplorerItem explorerItem = ExplorerThread.this.RootDir.removeItem("exit");
                printStream.println(" Rimosso:" + ((Object)explorerItem).toString());
                ExplorerThread.this.Stop();
                return explorerItem;
            }
        });
    }

    public void run() {
        try {
            String string;
            this.out.print(String.valueOf(this.Dir.BuildPath()) + "> ");
            while (this.Continue && (string = this.brIn.readLine()) != null) {
                try {
                    if (this.echo) {
                        this.out.println(string);
                    }
                    Object object = this.Dir.Execute(string, this.out);
                    this.out.println();
                    this.out.println("Result: " + object);
                    this.out.println();
                    if (object instanceof DirExplorerItem.ChangeDirMessage) {
                        this.Dir = ((DirExplorerItem.ChangeDirMessage)object).targetDirectory;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.out.print(String.valueOf(this.Dir.BuildPath()) + "> ");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

