/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.mobility;

import SOMA.Environment;
import SOMA.agent.AgentWorker;
import SOMA.agent.mobility.SavedWorker;
import SOMA.naming.AgentID;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AgentWorkerStore {
    private Hashtable workers = new Hashtable();

    public AgentWorker getWorker(AgentID agentID) {
        return (AgentWorker)this.workers.get(agentID);
    }

    public void printWorkers(PrintStream printStream) {
        Iterator iterator = this.workers.entrySet().iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            printStream.println("  " + n + ") " + entry.getKey() + " --> " + entry.getValue());
            ++n;
        }
    }

    public AgentWorker putWorker(AgentWorker agentWorker) {
        AgentWorker agentWorker2 = this.workers.put(agentWorker.agent.getID(), agentWorker);
        if (agentWorker2 != null) {
            System.err.println("ERRORE: sostituito il worker " + agentWorker2 + " non ancora eliminato");
        }
        return agentWorker2;
    }

    public AgentWorker removeWorker(AgentID agentID) {
        return (AgentWorker)this.workers.remove(agentID);
    }

    public List saveWorkers(Environment environment) {
        LinkedList<SavedWorker> linkedList = new LinkedList<SavedWorker>();
        Iterator iterator = this.workers.entrySet().iterator();
        environment.out.println("AgentWorkerStore: Saving workers:");
        int n = 1;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                SavedWorker savedWorker = new SavedWorker(environment, (AgentWorker)entry.getValue());
                linkedList.add(savedWorker);
                environment.out.println("  " + n + ") " + savedWorker);
            }
            catch (Exception exception) {
                environment.out.println("  " + n + ") ERROR: " + exception);
            }
            ++n;
        }
        environment.out.println();
        return linkedList;
    }

    public int workersNumber() {
        return this.workers.size();
    }
}

