/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.mobility;

import SOMA.Environment;
import SOMA.agent.Agent;
import SOMA.agent.AgentLauncherExplorerItem;
import SOMA.agent.AgentSystem;
import SOMA.agent.AgentWorker;
import SOMA.agent.AgentWorkerExplorerItem;
import SOMA.agent.Message;
import SOMA.agent.classLoading.AgentClassLoader;
import SOMA.agent.classLoading.ClassManager;
import SOMA.agent.classLoading.ClassManagerExplorerItem;
import SOMA.agent.mobility.AgentDeathCommand;
import SOMA.agent.mobility.AgentPacket;
import SOMA.agent.mobility.AgentPositionStore;
import SOMA.agent.mobility.AgentPositionUpdateCommand;
import SOMA.agent.mobility.AgentWorkerStore;
import SOMA.agent.mobility.BasicAgentPacket;
import SOMA.agent.mobility.PlaceAccessPermission;
import SOMA.agent.mobility.SavedWorker;
import SOMA.agent.mobility.SendMessageCommand;
import SOMA.agent.mobility.SystemAgentPacket;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import SOMA.explorer.ObjectExplorerItem;
import SOMA.explorer.StringExplorerItem;
import SOMA.naming.AgentID;
import SOMA.naming.PlaceID;
import SOMA.network.connection.Daemon;
import SOMA.utility.IndexHashtable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class AgentManager {
    Environment env;
    AgentSystem agentSystem;
    public ClassManager agentClassManager;
    public ClassManager cacheClassManager;
    public IndexHashtable indexStore = new IndexHashtable();
    StringExplorerItem path;
    StringExplorerItem cache;
    public int AgentIDCounter = 1;
    public AgentWorkerStore agentWorkerStore = new AgentWorkerStore();
    public AgentPositionStore agentPositionStore = new AgentPositionStore();
    DirExplorerItem agentManagerDir;
    public final int MAX_MESSAGE_ATTEMPTS = 6;

    public AgentManager(Environment environment) {
        this.env = environment;
        this.agentSystem = new AgentSystem(environment);
        this.agentManagerDir = new DirExplorerItem("agentManager");
        environment.dir.addItem(this.agentManagerDir);
        try {
            this.agentClassManager = new ClassManager(String.valueOf(System.getProperty("user.dir")) + File.separator + "agents", false);
            this.cacheClassManager = new ClassManager(String.valueOf(System.getProperty("user.dir")) + File.separator + "cache", false);
        }
        catch (Exception exception) {
            exception.printStackTrace(environment.err);
        }
        this.path = new ClassManagerExplorerItem(this.agentClassManager){

            public void update(ClassManager classManager) {
                AgentManager.this.agentClassManager = classManager;
            }
        };
        this.cache = new ClassManagerExplorerItem(this.cacheClassManager){

            public void update(ClassManager classManager) {
                AgentManager.this.cacheClassManager = classManager;
            }
        };
        this.agentManagerDir.addItem("path", this.path);
        this.agentManagerDir.addItem("cache", this.cache);
        this.agentManagerDir.addItem("store", new ObjectExplorerItem(this.indexStore));
        this.agentManagerDir.addItem("list", new ExplorerItem("List of agent workers"){

            public Object Execute(Collection collection, PrintStream printStream) {
                AgentManager.this.agentWorkerStore.printWorkers(printStream);
                return null;
            }
        });
        this.agentManagerDir.addItem("a", new AgentWorkerExplorerItem(environment));
        this.agentManagerDir.addItem("pos", new ExplorerItem("List of agents positions."){

            public Object Execute(Collection collection, PrintStream printStream) {
                AgentManager.this.agentPositionStore.printPositions(printStream);
                return null;
            }
        });
        this.agentManagerDir.addItem("death", new ExplorerItem("\"Agent ID\""){

            public Object Execute(Collection collection, PrintStream printStream) {
                try {
                    AgentManager.this.agentDeath(new AgentID((String)collection.iterator().next()));
                    printStream.println("DONE!");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }

            public String Help(PrintStream printStream) {
                printStream.println("Notifies an agent's death to his home place.");
                printStream.println("  Use it only if the agent is really dead!");
                return "Notifies an agent's death to his home place.";
            }
        });
        this.agentManagerDir.addItem("save", new ExplorerItem("Save agents to disk."){

            public Object Execute(Collection collection, PrintStream printStream) {
                try {
                    AgentManager.this.save();
                    printStream.println("Saved!");
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
        });
        this.agentManagerDir.addItem("load", new ExplorerItem("Load agents from disk."){

            public Object Execute(Collection collection, PrintStream printStream) {
                try {
                    AgentManager.this.load();
                    printStream.println("Loaded!");
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
        });
        AgentLauncherExplorerItem agentLauncherExplorerItem = new AgentLauncherExplorerItem(environment);
        this.agentManagerDir.addItem("launch", agentLauncherExplorerItem);
        environment.dir.addItem("launch", agentLauncherExplorerItem);
    }

    public void agentDeath(AgentID agentID) {
        if (agentID.getHome().equals(this.env.placeID)) {
            this.agentPositionStore.remove(agentID);
        } else {
            this.env.networkManager.sendCommand(agentID.getHome(), new AgentDeathCommand(agentID));
        }
    }

    public int agentsNumber() {
        return this.agentWorkerStore.workersNumber();
    }

    public AgentWorker createAgent(String string, Object object, boolean bl, boolean bl2) {
        AgentWorker agentWorker = null;
        try {
            AgentID agentID = this.newAgentID();
            ClassLoader classLoader = bl ? this.getClass().getClassLoader() : new AgentClassLoader(this.env, string, agentID);
            Agent agent = (Agent)classLoader.loadClass(string).newInstance();
            agent.setID(agentID);
            agent.putArgument(object);
            agent.setTraceable(bl2);
            agentWorker = this.createWorker(agent);
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
        }
        return agentWorker;
    }

    public AgentWorker createWorker(Agent agent) {
        AgentWorker agentWorker = null;
        try {
            if (System.getSecurityManager() == null || agent.getClass().getProtectionDomain().implies(new PlaceAccessPermission(this.env.placeID))) {
                agent.agentSystem = this.agentSystem;
                agentWorker = new AgentWorker(agent, this.env);
                this.agentWorkerStore.putWorker(agentWorker);
                if (agent.traceable) {
                    this.env.networkManager.sendCommand(agent.getID().getHome(), new AgentPositionUpdateCommand(agent.getID(), this.env.placeID));
                }
            } else {
                this.env.err.println("AgentManager.createWorker: Agent " + agent + " has no PlaceAccessPermission to " + this.env.placeID);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(this.env.err);
        }
        return agentWorker;
    }

    public void load() throws IOException, ClassNotFoundException {
        this.load(String.valueOf(this.env.placeID.toString()) + "_agents.dat");
    }

    public void load(String string) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(new File(string)));
        Hashtable hashtable = new Hashtable();
        hashtable = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        int n = (Integer)hashtable.get("count");
        int n2 = this.AgentIDCounter;
        if (n > n2) {
            this.AgentIDCounter = n;
            this.env.out.println("agent counter:" + n2 + " -->" + n);
        }
        this.agentPositionStore = (AgentPositionStore)hashtable.get("positions");
        this.env.out.println("positions: " + this.agentPositionStore);
        this.loadWorkers((List)hashtable.get("agents"));
        this.env.out.println("agents: DONE");
        this.env.out.println("Status loaded!");
    }

    public void loadWorkers(List list) {
        Iterator iterator = list.iterator();
        this.env.out.println("AgentManager: Loading workers:");
        int n = 1;
        while (iterator.hasNext()) {
            SavedWorker savedWorker = (SavedWorker)iterator.next();
            try {
                AgentID agentID = savedWorker.restoreWorker(this.env);
                this.env.out.println("  " + n + ") " + agentID + " loaded!");
            }
            catch (Exception exception) {
                this.env.out.println("  " + n + ") " + savedWorker + ": ERROR: " + exception);
            }
            ++n;
        }
        this.env.out.println();
    }

    public synchronized AgentID newAgentID() {
        return new AgentID(this.env.placeID, this.AgentIDCounter++);
    }

    public AgentPacket packAgent(Agent agent) {
        AgentPacket agentPacket = agent.getClass().getClassLoader() instanceof AgentClassLoader ? new BasicAgentPacket(agent) : new SystemAgentPacket(agent);
        return agentPacket;
    }

    public void save() throws IOException {
        this.save(String.valueOf(this.env.placeID.toString()) + "_agents.dat");
    }

    public void save(String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(string)));
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("count", new Integer(this.AgentIDCounter));
        this.env.out.println("count: " + this.AgentIDCounter);
        hashtable.put("positions", this.agentPositionStore);
        this.env.out.println("positions: " + this.agentPositionStore);
        hashtable.put("agents", this.agentWorkerStore.saveWorkers(this.env));
        this.env.out.println("agents: DONE");
        objectOutputStream.writeObject(hashtable);
        objectOutputStream.close();
        this.env.out.println("Status saved!");
    }

    public void sendMessage(Message message) {
        this.sendMessage(message, 0);
    }

    public synchronized void sendMessage(Message message, int n) {
        AgentWorker agentWorker = this.env.agentManager.agentWorkerStore.getWorker(message.to);
        if (agentWorker != null && agentWorker.getStatus() != AgentWorker.GONE) {
            agentWorker.agent.mailbox.storeMessage(message);
            if (agentWorker.getStatus() == Daemon.OFF || agentWorker.getStatus() == AgentWorker.IDLE || agentWorker.getStatus() == AgentWorker.STOPPED) {
                this.env.out.println("Waking up agent " + message.to);
                try {
                    agentWorker.start();
                }
                catch (AgentWorker.AgentWorkerException agentWorkerException) {
                    agentWorkerException.printStackTrace();
                }
            }
        } else if (n++ < 6) {
            SendMessageCommand sendMessageCommand = new SendMessageCommand(message, n);
            if (this.env.placeID.equals(message.to.getHome())) {
                PlaceID placeID = this.env.agentManager.agentPositionStore.get(message.to);
                if (placeID != null) {
                    this.env.networkManager.sendCommand(placeID, sendMessageCommand);
                } else {
                    this.env.err.println("AgentWorker.sendMessage: ERROR can't find agent: " + message.to);
                    this.env.err.println("MESSAGE " + message + "LOST!");
                }
            } else {
                this.env.networkManager.sendCommand(message.to.getHome(), sendMessageCommand);
            }
        } else {
            this.env.err.println("I have already tried " + n + " times to deliver this message:");
            this.env.err.println("   " + message + " DISCARDED.");
        }
    }

    public String toString() {
        return "[agentManager: " + this.agentsNumber() + " agents]";
    }
}

