/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.classLoading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ClassManager {
    File classPathDirectory;
    final boolean createDirectory;

    public ClassManager(String string) throws ClassManagerException {
        this(string, false);
    }

    public ClassManager(String string, boolean bl) throws ClassManagerException {
        this.createDirectory = bl;
        this.classPathDirectory = new File(string);
        if (!this.classPathDirectory.isDirectory() && bl && !this.classPathDirectory.mkdirs()) {
            throw new ClassManagerException("Can't create dir: " + this.classPathDirectory);
        }
    }

    public String getClassPathDirectory() {
        return this.classPathDirectory.getAbsolutePath();
    }

    public boolean getCreateDirectory() {
        return this.createDirectory;
    }

    byte[] loadClassFile(String string) throws IOException {
        byte[] byArray = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.classPathDirectory, String.valueOf(string.replace('.', '/')) + ".class")));
        int n = bufferedInputStream.available();
        int n2 = 0;
        byArray = new byte[n];
        while (n2 < n) {
            int n3 = bufferedInputStream.read(byArray, n2, n - n2);
            n2 += n3;
        }
        bufferedInputStream.close();
        return byArray;
    }

    void saveClassFile(String string, byte[] byArray) throws ClassManagerException, IOException {
        File file = new File(this.classPathDirectory, String.valueOf(string.replace('.', '/')) + ".class");
        File file2 = file.getParentFile();
        if (file2 != null && !file2.isDirectory() && !file2.mkdirs()) {
            throw new ClassManagerException("Can't create dir: " + this.classPathDirectory);
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    public static class ClassManagerException
    extends Exception {
        public ClassManagerException(String string) {
            super(string);
        }
    }
}

