/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent.classLoading;

import SOMA.Environment;
import SOMA.agent.classLoading.ClassRequestCommand;
import SOMA.naming.AgentID;
import SOMA.utility.WaitAndTimeout;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.TreeSet;

public class AgentClassLoader
extends SecureClassLoader {
    Environment env;
    CodeSource codeSource;
    AgentID agentID;
    Set loadedClassesSet = new TreeSet();

    public AgentClassLoader(Environment environment, String string, AgentID agentID) {
        this.env = environment;
        this.agentID = agentID;
        this.codeSource = new CodeSource(AgentClassLoader.AgentToURL(string, agentID), new Certificate[0]);
    }

    public static URL AgentToURL(String string, AgentID agentID) {
        try {
            return new URL("http://" + agentID.place.domain + "/" + agentID.place.place + "/" + string + "/" + agentID.ID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected Class findClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return this.myFindClass(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ClassNotFoundException("AgentClassManager.findClass: Exception on Class " + string, privilegedActionException.getException());
        }
    }

    public Class findFromRemote(final String string) throws ClassNotFoundException {
        Thread thread;
        WaitAndTimeout waitAndTimeout = new WaitAndTimeout(60000L, "class " + string, this.env.out);
        int n = this.env.agentManager.indexStore.put(waitAndTimeout);
        int n2 = this.env.agentManager.indexStore.put(new Object());
        byte[] byArray = null;
        try {
            this.env.networkManager.startPermanentConnection(this.agentID.getHome());
            if (!this.env.networkManager.sendCommand(this.agentID.getHome(), new ClassRequestCommand(string, this.env.placeID, n2, n))) {
                throw new ClassNotFoundException("AgentClassManager.findClass: can't send ClassRequestCommand.");
            }
            if (waitAndTimeout.Wait() == 2) {
                this.env.err.println(String.valueOf(this.toString()) + "PROBLEMA DI CLASSLOADING. Aspetto 20 secondi prima di lanciare l'eccezione!");
                AgentClassLoader agentClassLoader = this;
                synchronized (agentClassLoader) {
                    try {
                        this.wait(20000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(this.env.err);
                    }
                    this.env.err.println(String.valueOf(this.toString()) + "Ora vado.");
                }
                throw new ClassNotFoundException("AgentClassManager.findClass: Receive class TIMEOUT EXPIRED.");
            }
            byArray = (byte[])this.env.agentManager.indexStore.get(n2);
        }
        finally {
            thread = null;
            this.env.agentManager.indexStore.remove(n);
            this.env.agentManager.indexStore.remove(n2);
            this.env.networkManager.stopPermanentConnection(this.agentID.getHome());
        }
        if (byArray != null) {
            final byte[] byArray2 = byArray;
            thread = new Thread("[Cache Saver: " + string + "]"){

                public void run() {
                    Thread.yield();
                    try {
                        env.agentManager.cacheClassManager.saveClassFile(string, byArray2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            thread.setPriority(1);
            thread.start();
        }
        return this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
    }

    public Set getLoadedClassesSet() {
        return this.loadedClassesSet;
    }

    private Class myFindClass(String string) throws Exception {
        Class<?> clazz = null;
        if (this.agentID.getHome().equals(this.env.placeID)) {
            try {
                byte[] byArray = this.env.agentManager.agentClassManager.loadClassFile(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
            }
            catch (Exception exception) {
                byte[] byArray = this.env.agentManager.cacheClassManager.loadClassFile(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
            }
        } else {
            try {
                byte[] byArray = this.env.agentManager.cacheClassManager.loadClassFile(string);
                clazz = this.defineClass(string, byArray, 0, byArray.length, this.codeSource);
            }
            catch (Exception exception) {
                clazz = this.findFromRemote(string);
            }
        }
        this.loadedClassesSet.add(string);
        return clazz;
    }

    public String toString() {
        return "[AgentClassLoader " + this.agentID + " <-> " + this.codeSource + "]";
    }
}

