/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent;

import SOMA.Environment;
import SOMA.agent.AgentWorker;
import SOMA.agent.CantGoException;
import SOMA.explorer.ExplorerItem;
import SOMA.mobilePlace.MobilePlaceID;
import SOMA.naming.AgentID;
import SOMA.naming.PlaceID;
import SOMA.utility.ThreadsExplorerItem;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

public class AgentWorkerExplorerItem
extends ExplorerItem {
    Environment env;

    public AgentWorkerExplorerItem(Environment environment) {
        super("\"Agent ID\" {start | stop | status | dom | remove | kill | go \"Place ID\"}");
        this.env = environment;
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        AgentWorker agentWorker = null;
        if (collection.size() == 0) {
            this.Help(printStream);
        } else {
            Iterator iterator = collection.iterator();
            AgentID agentID = null;
            try {
                agentID = new AgentID((String)iterator.next());
            }
            catch (Exception exception) {
                printStream.println("AgentID ERROR: " + exception.toString());
                return null;
            }
            PlaceID placeID = this.env.agentManager.agentPositionStore.get(agentID);
            if (placeID != null) {
                printStream.println();
                printStream.println("Agent " + agentID + " is in place " + placeID);
                printStream.println();
            }
            if ((agentWorker = this.env.agentManager.agentWorkerStore.getWorker(agentID)) == null) {
                printStream.println();
                printStream.println("Agent " + agentID + " NOT FOUND ");
                printStream.println();
                return null;
            }
            String string = "";
            if (iterator.hasNext()) {
                string = (String)iterator.next();
            }
            if (string.equals("start")) {
                try {
                    agentWorker.start();
                    printStream.println("Started-->" + agentWorker);
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("stop")) {
                try {
                    agentWorker.stop();
                    printStream.println("Stopped-->" + agentWorker);
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                    return null;
                }
            }
            if (string.equals("remove")) {
                try {
                    agentWorker.remove();
                    printStream.println("Removed -->" + agentWorker);
                }
                catch (Exception exception) {
                    printStream.println("ERROR: " + exception);
                    return null;
                }
            }
            if (string.equals("kill")) {
                try {
                    agentWorker.kill();
                    printStream.println("killed -->" + agentWorker);
                }
                catch (Exception exception) {
                    printStream.println("ERROR: " + exception);
                    return null;
                }
            }
            if (string.equals("go")) {
                PlaceID placeID2 = null;
                try {
                    placeID2 = MobilePlaceID.parsePlaceID((String)iterator.next());
                }
                catch (Exception exception) {
                    printStream.println("I need a valid PlaceID: " + exception);
                    return null;
                }
                try {
                    agentWorker.go(placeID2);
                }
                catch (CantGoException cantGoException) {
                    printStream.println("ERROR: " + cantGoException);
                }
            } else if (string.equals("dom")) {
                printStream.println("Worker " + agentWorker);
                printStream.println();
                printStream.println("Protection domain: " + agentWorker.agent.getClass().getProtectionDomain());
                printStream.println();
            } else if (string.equals("status") || string.equals("")) {
                printStream.println("Worker " + agentWorker);
                printStream.println("Status: " + agentWorker.getStatus());
                printStream.println();
                printStream.println("Agent class: " + agentWorker.agent.getClass());
                printStream.println("Class loader: " + agentWorker.agent.getClass().getClassLoader());
                printStream.println();
                printStream.println("Source URL: " + agentWorker.agent.getClass().getProtectionDomain().getCodeSource().getLocation());
                printStream.println();
                printStream.println("Active threads: ");
                ThreadsExplorerItem.Enumerate(agentWorker.agentThreadGroup, printStream);
                printStream.println();
            } else {
                printStream.println("Unknown operation: " + string);
            }
        }
        return agentWorker;
    }

    public String Help(PrintStream printStream) {
        printStream.println("  start: starts the agent.");
        printStream.println("  stop: stops the agent.");
        printStream.println("  status: returns the agent's status.");
        printStream.println("  dom: returns the agent's protection domain.");
        printStream.println("  remove: removes the agent, if in OFF status.");
        printStream.println("  kill: kills the agent.");
        printStream.println("  go: moves the agent to another place.");
        return this.toString();
    }
}

