/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent;

import SOMA.Environment;
import SOMA.agent.AgentWorker;
import SOMA.explorer.ExplorerItem;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class AgentLauncherExplorerItem
extends ExplorerItem {
    Environment env;
    public static final String SYSTEM_CLASSLOADER = "-s";
    public static final String NOT_TRACEABLE = "-nt";
    public static final String NO_START = "-ns";

    public AgentLauncherExplorerItem(Environment environment) {
        super("[-s] [-nt] [-ns] \"Agent ID\" { \"Arg1\" \"Arg2\" ... }");
        this.env = environment;
    }

    public Object Execute(Collection collection, PrintStream printStream) {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            printStream.println(string);
            if (!string.startsWith("-")) break;
            iterator.remove();
            hashSet.add(string);
        }
        if ((iterator = collection.iterator()).hasNext()) {
            AgentWorker agentWorker;
            string = (String)iterator.next();
            iterator.remove();
            printStream.println("Agent class: " + string);
            int n = collection.size();
            String[] stringArray = new String[n];
            printStream.println("Creating agent: " + string + " Parameters: ");
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)iterator.next();
                printStream.println("  " + n2 + ")  " + stringArray[n2]);
                ++n2;
            }
            if (hashSet.contains(SYSTEM_CLASSLOADER)) {
                printStream.println("-s ==> Using System ClassLoader.");
            }
            if (hashSet.contains(NOT_TRACEABLE)) {
                printStream.println("-nt ==> Not Traceable agent.");
            }
            if (hashSet.contains(NO_START)) {
                printStream.println("-ns ==> No Start: the agent will not be started.");
            }
            if ((agentWorker = this.env.agentManager.createAgent(string, stringArray, hashSet.contains(SYSTEM_CLASSLOADER), hashSet.contains(NOT_TRACEABLE) ^ true)) == null) {
                printStream.println("ERROR: can't create agent.");
            } else if (hashSet.contains(NO_START)) {
                printStream.println("Worker: " + agentWorker + " created, but not started.");
            } else {
                try {
                    agentWorker.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                printStream.println("Worker: " + agentWorker + " created and started.");
            }
            return agentWorker;
        }
        printStream.println("Invalid parameters.");
        return null;
    }

    public String Help(PrintStream printStream) {
        printStream.println();
        printStream.println("Launch an agent with the specified options ");
        printStream.println("  and parameters: " + this.toString());
        printStream.println();
        printStream.println("\"agent ID\" --> Agent class name (no .class suffix).");
        printStream.println();
        printStream.println("{ \"Arg1\" \"Arg2\" ... } --> Optional arguments. They will be passed in a ");
        printStream.println("     String[] to Agent.putArgument( Object obj ).");
        printStream.println();
        printStream.println("-s --> Use System ClassLoader. The agent will use the default");
        printStream.println("     Java security protection mechanisms");
        printStream.println();
        printStream.println("-nt --> Not Traceable agent. The agent will not be traceable and ");
        printStream.println("     he will not have a Mailbox to receive messages.");
        printStream.println();
        printStream.println("-ns ==> No Start: the agent will not be started. It is possible to ");
        printStream.println("     move the agent to another place (Worker.go(...)) or to start it later.");
        printStream.println();
        return this.getSyntax();
    }
}

