/*
 * Decompiled with CFR 0.152.
 */
package SOMA.agent;

import SOMA.agent.AgentSystem;
import SOMA.agent.AgentWorker;
import SOMA.agent.CantGoException;
import SOMA.agent.Mailbox;
import SOMA.naming.AgentID;
import SOMA.naming.PlaceID;
import java.io.Serializable;

public abstract class Agent
implements Serializable {
    private AgentID myID = null;
    public String start = "run";
    public transient AgentSystem agentSystem = null;
    public Mailbox mailbox = null;
    public boolean traceable = false;
    transient AgentWorker worker = null;

    public final AgentID getID() {
        return this.myID;
    }

    public final void go(PlaceID placeID, String string) throws CantGoException {
        this.start = string;
        this.agentSystem.go(this, placeID);
    }

    public final void idle(String string) {
        this.start = string;
        this.agentSystem.idle(this);
    }

    public void putArgument(Object object) {
    }

    public abstract void run();

    public final void setID(AgentID agentID) {
        if (this.myID != null) {
            throw new RuntimeException("Agent.setID: trying to change agentID!!!");
        }
        this.myID = agentID;
    }

    public final void setTraceable(boolean bl) {
        this.traceable = bl;
        if (bl && this.mailbox == null) {
            this.mailbox = new Mailbox();
        }
    }

    public void stop() {
        throw new UnsupportedOperationException("Abstract Agent doesn't support this operation.");
    }

    public String toString() {
        return "[Agent: " + this.myID + (this.mailbox == null ? " not traceable" : " " + this.mailbox) + "]";
    }
}

