/*
 * Decompiled with CFR 0.152.
 */
package SOMA;

import SOMA.agent.mobility.AgentManager;
import SOMA.explorer.DirExplorerItem;
import SOMA.explorer.ExplorerItem;
import SOMA.explorer.ObjectExplorerItem;
import SOMA.mobilePlace.MobilePlaceManager;
import SOMA.mobilePlace.MobilePlaceManagerExplorerItem;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DNSExplorerItem;
import SOMA.naming.domain.DomainNameService;
import SOMA.naming.place.PNSExplorerItem;
import SOMA.naming.place.PlaceNameService;
import SOMA.network.NetworkManager;
import SOMA.network.connection.DaemonExplorerItem;
import SOMA.output.PlaceWindow;
import SOMA.telnet.MultiOutputStream;
import SOMA.utility.ThreadsExplorerItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;

public class Environment {
    public final PlaceID placeID;
    public NetworkManager networkManager = null;
    public DirExplorerItem dir;
    public DomainNameService domainNameService;
    public PlaceNameService placeNameService;
    public AgentManager agentManager;
    public MobilePlaceManager mobilePlaceManager;
    public InputStream in;
    public MultiOutputStream multiOut = new MultiOutputStream();
    public PrintStream out = new PrintStream(this.multiOut);
    public MultiOutputStream multiErr = new MultiOutputStream();
    public PrintStream err = new PrintStream(this.multiErr);
    public ThreadGroup threadGroup = null;
    private Exception creationException = null;

    public Environment(DirExplorerItem dirExplorerItem, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        this.dir = dirExplorerItem;
        this.in = inputStream;
        this.multiOut.add(printStream);
        this.multiErr.add(printStream2);
        this.placeID = new PlaceID("???", "???");
    }

    public Environment(PlaceID placeID, final DirExplorerItem dirExplorerItem, final int n, InputStream inputStream, final PrintStream printStream, PrintStream printStream2) throws Exception {
        this.placeID = placeID;
        this.dir = dirExplorerItem;
        this.in = inputStream;
        this.multiOut.add(printStream);
        this.multiErr.add(printStream2);
        dirExplorerItem.addItem("env", new ObjectExplorerItem(this));
        dirExplorerItem.addItem("window", new DaemonExplorerItem(new PlaceWindow(this)));
        this.createNameServices();
        if (placeID.isDomain()) {
            this.mobilePlaceManager = new MobilePlaceManager(this);
        }
        this.threadGroup = new ThreadGroup("[Environment:" + placeID + "]");
        this.threadGroup.setDaemon(true);
        Thread thread = new Thread(this.threadGroup, String.valueOf(this.toString()) + " Initialization Thread."){

            public void run() {
                try {
                    networkManager = new NetworkManager(this, n);
                    printStream.println("NewtworkManager created!");
                    agentManager = new AgentManager(this);
                    printStream.println("AgentManager created!");
                    dirExplorerItem.addItem("threads", new ThreadsExplorerItem());
                }
                catch (Exception exception) {
                    creationException = exception;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
        thread.join();
        if (this.creationException != null) {
            throw this.creationException;
        }
        dirExplorerItem.addItem("text", new ExplorerItem("Writes text to 3 different PrintStreams."){

            public Object Execute(Collection collection, PrintStream printStream) {
                printStream.println("********** Testo di Explorer! *********");
                Environment.this.out.println("----------- Testo di PlaceWindow! -----------");
                System.out.println("############## Testo di System! ##############");
                return null;
            }
        });
        dirExplorerItem.addItem("save", new ExplorerItem("Save place info to disk."){

            public Object Execute(Collection collection, PrintStream printStream) {
                try {
                    Environment.this.save();
                    printStream.println("Saved!");
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
        });
        dirExplorerItem.addItem("load", new ExplorerItem("Load place info from disk."){

            public Object Execute(Collection collection, PrintStream printStream) {
                try {
                    Environment.this.load();
                    printStream.println("Loaded!");
                }
                catch (Exception exception) {
                    exception.printStackTrace(printStream);
                }
                return null;
            }
        });
    }

    static /* synthetic */ Exception access$0(Environment environment) {
        return environment.creationException;
    }

    protected void createNameServices() {
        if (this.placeID.isDomain()) {
            this.domainNameService = new DomainNameService(this);
            this.dir.addItem("dns", new DNSExplorerItem(this.domainNameService));
        }
        this.placeNameService = new PlaceNameService(this);
        this.dir.addItem("pns", new PNSExplorerItem(this.placeNameService));
    }

    public void load() throws IOException, ClassNotFoundException {
        this.load(String.valueOf(this.placeID.toString()) + ".dat");
    }

    public void load(String string) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(new File(string)));
        Hashtable hashtable = new Hashtable();
        hashtable = (Hashtable)objectInputStream.readObject();
        objectInputStream.close();
        this.placeNameService = (PlaceNameService)hashtable.get("pns");
        if (this.placeNameService != null) {
            this.placeNameService.setEnv(this);
            this.out.println("pns:" + this.placeNameService);
            this.dir.addItem("pns", new PNSExplorerItem(this.placeNameService));
        }
        this.domainNameService = (DomainNameService)hashtable.get("dns");
        if (this.domainNameService != null) {
            this.domainNameService.setEnv(this);
            this.out.println("dns:" + this.domainNameService);
            this.dir.addItem("dns", new DNSExplorerItem(this.domainNameService));
        }
        this.mobilePlaceManager = (MobilePlaceManager)hashtable.get("mpm");
        if (this.mobilePlaceManager != null) {
            this.mobilePlaceManager.setEnv(this);
            this.dir.addItem("mpm", new MobilePlaceManagerExplorerItem(this.mobilePlaceManager));
            this.out.println("mpm:" + this.mobilePlaceManager);
        }
        if ((n2 = ((Integer)hashtable.get("count")).intValue()) > (n = this.agentManager.AgentIDCounter)) {
            this.agentManager.AgentIDCounter = n2;
            this.out.println("agent counter:" + n + " -->" + n2);
        }
        this.out.println("Status loaded!");
    }

    public void save() throws IOException {
        this.save(String.valueOf(this.placeID.toString()) + ".dat");
    }

    public void save(String string) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(new File(string)));
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        hashtable.put("pns", this.placeNameService);
        this.out.println("pns:" + this.placeNameService);
        hashtable.put("dns", this.domainNameService);
        this.out.println("dns:" + this.domainNameService);
        hashtable.put("mpm", this.mobilePlaceManager);
        this.out.println("mpm:" + this.mobilePlaceManager);
        hashtable.put("count", new Integer(this.agentManager.AgentIDCounter));
        this.out.println("agent counter:" + this.agentManager.AgentIDCounter);
        objectOutputStream.writeObject(hashtable);
        objectOutputStream.close();
        this.out.println("Status saved!");
    }

    public String toString() {
        return "[Environment " + this.placeID + " " + this.networkManager + " " + this.domainNameService + " " + this.placeNameService + " " + this.agentManager + " " + this.mobilePlaceManager + "]";
    }
}

