%%%%%%%% Constant Part %%%%%%%%

society_goal:-
	h(start,0).
	

conflicts:-
	\+(simulateOne).

deadActivities:-
	unknown(_, fail),
	set_option(fulfiller, on),
	activities(Activities),
	deadActivities(Activities).
	
deadActivities(Activities):-
	deadActivities(Activities, Result),
	printResult(Result).


deadActivities([],[]).

deadActivities([H|T],[H|T2]):-
	deadActivity(H), !,
	deadActivities(T,T2).
	
deadActivities([H|T],L):-
	deadActivities(T,L).


deadActivity(A):-
	assert(verifyDeadActivity(A)),
	\+(run), !, 
	retract(verifyDeadActivity(A)).

deadActivity(A):-
	retract(verifyDeadActivity(A)),
	fail.


printResult(Result):-
	printRecursiveResult(Result).

printRecursiveResult([]).
printRecursiveResult([H|T]):-
	write(H),nl,
	printRecursiveResult(T).

	
groundSimulate:-
	unknown(_, fail),
	set_option(fulfiller, on),
	run, 
	make_choice, 
	ground_time.

simulate:-
	unknown(_, fail),
	set_option(fulfiller, on),
	statistics(runtime, _),
	run.
	
	
simulateOne:-
	set_option(fulfiller, on),
	unknown(_, fail),
	statistics(runtime, _),
	run,
	!, 
	statistics(runtime, [_, Time]),
	writeln('running_time '),
	writeln(Time).
	
simulateOne:-inconsistencyHandling.

inconsistencyHandling:-
	statistics(runtime, [_, Time]),
	writeln(inconsistency),
	writeln('running_time '),
	writeln(Time).
	
	
	





