/*
 * @(#)URLReaderWithOptions.java	1.1 99/10/06
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import java.net.*;
import java.io.*;

/*
 * Using a URL to access resources on a secure site. 
 * It sets up the security provider dynamically.
 *
 * You can optionally set the following command line options:
 *
 *     -h <secure proxy server hostname>
 *     -p <secure proxy server port>
 *     -k <| separated list of protocol handlers>
 *     -c <enabled cipher suites as a comma separated list>
 *
 */

public class URLReaderWithOptions {
    public static void main(String[] args) throws Exception {

	// Dynamic registration of JSSE provider 
	java.security.Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

	System.out.println("USAGE: java URLReaderWithOptions [-h proxyhost -p proxyport] [-k protocolhandlerpkgs] [-c ciphersarray]");

	// initialize system properties
	char option = 'd';
	for (int i = 0; i < args.length; i++) { 
	    System.out.println(option+": "+args[i]);
	    switch(option) {
	    case 'h':
		System.setProperty("https.proxyHost", args[i]);
		option = 'd';
		break;
	    case 'p':
		System.setProperty("https.proxyPort", args[i]);
		option = 'd';
		break;
	    case 'k':
		System.setProperty("java.protocol.handler.pkgs", args[i]);
		option = 'd';
		break;
	    case 'c':
		System.setProperty("https.cipherSuites", args[i]);
		option = 'd';
		break;
	    default:
		// get the next option
		if (args[i].startsWith("-")) {
		    option = args[i].charAt(1);
		}
	    }
	}

	URL verisign = new URL("https://www.verisign.com/");
	BufferedReader in = new BufferedReader(
				new InputStreamReader(
				verisign.openStream()));

	String inputLine;

	while ((inputLine = in.readLine()) != null)
	    System.out.println(inputLine);

	in.close();
    }
}
