/*
 * @(#)SSLSocketClientWithClientAuth.java	1.2 99/11/03
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */


import java.net.*;
import java.io.*;
import javax.net.ssl.*;
import javax.security.cert.X509Certificate;
import com.sun.net.ssl.*;
import java.security.KeyStore;

/* 
 * This example shows how to set up a key manager to do client
 * authentication if required by server.
 *
 * This program assumes that the client is not inside a firewall. You can 
 * modify the program to connect from inside a firewall by following what's
 * been done in SSLSocketClientWithTunneling.java.
 * 
 */


public class SSLSocketClientWithClientAuth {
    
    public static void main(String[] args) throws Exception {
	String host = null;
	int port = -1;
	String path = null;
	for (int i = 0; i < args.length; i++)
	    System.out.println(args[i]);

	if (args.length < 3) {
	    System.out.println("USAGE: java SSLSocketClientWithClientAuth host port requestedfilepath");
	    System.exit(-1);
	}
	try {
	    host = args[0];
	    port = Integer.parseInt(args[1]);
	    path = args[2];
	} catch (IllegalArgumentException e) {
	     System.out.println("USAGE: java SSLSocketClientWithClientAuth host port requestedfilepath");
	     System.exit(-1);
	}

	try {
	    // set up a key manager so that we can do client authentication
	    // if asked by server
	    SSLSocketFactory factory = null;
	    try {
		SSLContext ctx;
		KeyManagerFactory kmf;
		KeyStore ks;
		char[] passphrase = "passphrase".toCharArray();
		
		ctx = SSLContext.getInstance("TLS");
		kmf = KeyManagerFactory.getInstance("SunX509");
		ks = KeyStore.getInstance("JKS");
		
		ks.load(new FileInputStream("testkeys"), passphrase);
		
		kmf.init(ks, passphrase);
		ctx.init(kmf.getKeyManagers(), null, null);
		
		factory = ctx.getSocketFactory();
	    } catch (Exception e) {
		throw new IOException(e.getMessage());
	    }
	    
	    
	    SSLSocket socket = (SSLSocket)factory.createSocket(host, port);

	    // send http request
	    PrintWriter out = new PrintWriter(
				  new BufferedWriter(
				  new OutputStreamWriter(
     				  socket.getOutputStream())));
	    out.println("GET "+path+" HTTP/1.1");
	    out.println();
	    out.flush();						       

	    // read response
	    BufferedReader in = new BufferedReader(
				    new InputStreamReader(
				    socket.getInputStream()));

	    String inputLine;

	    while ((inputLine = in.readLine()) != null)
		System.out.println(inputLine);

	    in.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
