/*
 * @(#)SSLSocketClient.java	1.1 99/10/06
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import java.net.*;
import java.io.*;
import javax.net.ssl.*;

/* 
 * This example demostrates how to use a SSLSocket as client to
 * send a HTTP request and get response from an HTTPS server.
 * It assumes that the client is not behind a firewall
 * 
 */

public class SSLSocketClient {
    
    public static void main(String[] args) throws Exception {
	try {
	    SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
	    SSLSocket socket = (SSLSocket)factory.createSocket("www.verisign.com", 443);

	    // send http request
	    // before any application data gets sent or received, 
	    // ssl socket will do ssl handshaking first to set up
	    // the security associates
	    PrintWriter out = new PrintWriter(
				  new BufferedWriter(
				  new OutputStreamWriter(
     				  socket.getOutputStream())));
	    out.println("GET http://www.verisign.com/index.html HTTP/1.1");
	    out.println();
	    out.flush();						       

	    // read response
	    BufferedReader in = new BufferedReader(
				    new InputStreamReader(
				    socket.getInputStream()));

	    String inputLine;

	    while ((inputLine = in.readLine()) != null)
		System.out.println(inputLine);

	    in.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}
