/*
 * @(#)HelloImpl.java	1.1 99/10/06
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.RMISecurityManager;
import java.rmi.server.UnicastRemoteObject;
        
public class HelloImpl extends UnicastRemoteObject implements Hello {
        
    public HelloImpl() throws RemoteException {
	// super();
	super(0, new RMISSLClientSocketFactory(), 
                 new RMISSLServerSocketFactory());
    }
        
    public String sayHello() {
	return "Hello World!";
    }
        
    public static void main(String args[]) {
        
	// Create and install a security manager
	if (System.getSecurityManager() == null) {
	    System.setSecurityManager(new RMISecurityManager());
	}
        
	try {
	    HelloImpl obj = new HelloImpl();
        
	    // Bind this object instance to the name "HelloServer"
	    Naming.rebind("//"+InetAddress.getLocalHost().getHostName()+"/HelloServer", obj);
        
	    System.out.println("HelloServer bound in registry");
	} catch (Exception e) {
	    System.out.println("HelloImpl err: " + e.getMessage());
	    e.printStackTrace();
	}
    }
}
