function es_temperature()
	% Dimensioni della stanza
	l1 = 9; % profondita'
	l2 = 5; % larghezza
	l3 = 3.5; % altezza
	lg = 2.5; % larghezza della porta finestra
	lw = 0.25; % spessore dei mattoni nelle pareti
	% Grandezze derivate
	Va = l1 * l2 * l3; % volume dell'aria all'interno
	Sg = lg * l3; % superficie della porta finestra
	Sw = 2*l1*l2 + 2*l2*l3 + 2*l1*l3 - Sg; % superficie delle pareti

	% Resistenza dell'aria sulla porta finestra
	R1 = 1 / (0.024 * 1e3 * Sg * 2e2);
	% Resistenza tra l'aria nella stanza e le pareti
	R2 = 1 / (0.7 * 1e3 * Sw * 1.5);
	% Capacita' termica dell'aria nella stanza
	Ca = 1.005 * 1e3 * Va * 1.1839;

	% Temperature esterna e dei muri
	To = 17;
	Tw = 22;

	% Costruisco la matrice dei coefficienti
	A = [   1,     0, +1/R1;
		    0,     1, -1/R2;
		 1/Ca, -1/Ca,     0]
	b = [To/R1; -Tw/R2; 0]

	% Risolvo il sistema
	xeq = A \ b

	% Temperature dell'aria interna
	Ta = xeq(3)
end
