function es_riverbed()
	% Dati del problema
	x0 = 0;
	x1 = 30;
	d0 = 0;
	d1 = 0;
	s1 = 120;

	% Impostazione del sistema di eq. lineari
	A = [    x0^2,       x0, 1;	% Estremo di sx
	   	  x1^2,       x1, 1;	% Estremo di dx
	     1/3*x1^3, 1/2*x1^2, x1];	% Condizione sulla sezione (integrale)
	b = [d0; d1; s1];

	% Risolvo il sistema
	p = A \ b;

	% Preparo una funzione anonima per facilitare il disegno
	f = @(x) polyval(p, x);
	% Range per il disegno
	x = linspace(x0, x1);

	% Disegno la sezione
	plot(x, f(x), 'linewidth', 2);
	grid()
	xlabel('Posizione', 'fontsize', 14)
	ylabel('Profondita', 'fontsize', 14)
	axis('equal') % Stessa scala per i due assi (per avere proporzioni realistiche)

	% Determino la massima profondita'
	xmax = -p(2) / (2*p(1)); % Trovo la posizione del massimo per via analitica
	dmax = f(xmax)
end
