function es_pagerank_eq()
	% Probabilita' di ri-iniziare
	p = 0.1;
	% Probabilita' di passare ad una pagina adiacente
	P = [ 0.0, 0.0, 0.5;
		  0.5, 0.0, 0.5;
		  0.5, 1.0, 0.0];
	% Ottengo (indirettamte) il numero di pagine
	[n, m] = size(P); % m non mi serve

	% Stato iniziale (tutte le pagine sono equiprobabili)
	x0 = 1/n * ones(1, n); % vettore riga

	% Intervallo di simulazione
	T = 1:10;

	% Simualzione
	f = @(x, t) browse(x, P, p, n);
	X = simulate(f, T, x0);

	% % Disegno l'andamento delle probabilita
	% figure()
	% plot(T, X(:, 1))
	% hold on
	% plot(T, X(:, 2))
	% plot(T, X(:, 3))
	% legend('P1', 'P2', 'P3')
	% hold off

	% Determino le probabilita' finali risolvendo un sistema di eq. lineari
	% I*x = (1-p)*P*x + p/n --> (I - (1-p)*P) * x  = p/n
	A = (eye(n) - (1-p)*P)
	b = (ones(n,1) * p/n)
	xeq = A \ b

	% Visualizzo l'ultimo stato simulato e controllo che coincida con i valori
	% appena calcolati
	xfinal = X(end, :)
end

function xf = browse(xc, P, p, n)
	xc = xc'; % Traspongo (mi serve un vettore colonna)
	xf = (1-p) * P * xc + p / n;
	xf = xf'; % Traspongo, ottenendo un vettore riga
end

