function es_frame()
	 % Dati del problema
	 x0 = 0;
	 y0 = 0;
	 x1 = 0.4;
	 y1 = 0.35;
	 x2 = 0.6;
	 y2 = -0.13;
	 x3 = 1.1;

	 % Definisco un sistema di eq. lineari
	 A = [x0^2, x0, 1,     0,   0,  0;
		  x1^2, x1, 1,     0,   0,  0;
			 0,  0, 0,  x0^2,  x0,  1;
			 0,  0, 0,  x2^2,  x2,  1;
		  x3^2, x3, 1, -x3^2, -x3, -1;
		  2*x0,  1, 0, -2*x3,  -1,  0];
	 b = [y0; y1; y0; y2; 0; 0];

	 % Risolvo il sistema e determino i parametri
	 p = A \ b

	 % Preparo due funzioni anonime, una pe ognuna delle curve
	 f1 = @(x) polyval(p(1:3), x);
	 f2 = @(x) polyval(p(4:6), x);

	 % Disegno le due curve
	 x = linspace(x0, x3);
	 plot(x, f1(x), 'linewidth', 2);
	 hold on
	 plot(x, f2(x), 'linewidth', 2);
	 % y3 = f1(x3) % Determino la coordinata y in x3
	 % scatter([x0, x1, x2, x3], [y0, y1, y2, y3], 'linewidth', 2)
	 hold off
	 grid()
	 xlabel('X', 'fontsize', 14)
	 ylabel('Y', 'fontsize', 14)
	 axis('equal')
end
