function es_arc()
	% Dati del problema
	x0 = 0;
	x1 = 2;
	x2 = 6;
	y0 = 3;
	y2 = 0;

	% Trovo i parametri della curva
	A = [	x0^2, x0, 1;	% Passaggio per il primo punto
			x2^2, x2, 1;	% Passagio per il secondo punto
			2*x1,  1, 0];	% Condizione sulla derivata (quota massima)
	b = [y0; y2; 0];

	% Parametri della curva (una parabola)parabola
	p = A \ b 

	% Preparo una funzione anonima per facilitare il disegno
	f = @(x) polyval(p, x);
	% Range per il disegno
	x = linspace(x0, x2);

	% Disegno la curva
	plot(x, f(x), 'linewidth', 2);
	grid()

	% Determino l'altezza massima
	ymax = f(x1);
	fprintf('Altezza massima = %.2f\n', ymax);
end
