function es_accelaration()
	% Dati del problema
	t0 = 0;
	t1 = 3;
	v0 = 0;
	v1 = 5.5;

	% Impostazione della soluzione
	A = [	t0^3, t0^2, t0, 1;	% Velocita' iniziale
			t1^3, t1^2, t1, 1;	% Velocita' finale
			3*t0^2, 2*t0,  1, 0;	% Derivata iniziale
			3*t1^2, 2*t1,  1, 0]	% Derivata finale
	b = [v0; v1; 0; 0];

	% Determino il valore dei parametri
	p = A \ b

	% Una funzione anonima per rendere piu' semplice disegnare la curva
	f = @(t) polyval(p, t);
	% Range per il disegno
	t = linspace(t0, t1);

	% Disegno il profilo di velocita'
	plot(t, f(t), 'linewidth', 2);
	grid()
	xlabel('Tempo', 'fontsize', 14)
	ylabel('Velocita''', 'fontsize', 14)
end
