function es_weather()
	% Definisco la matrice di transizione
	P = [0.9, 0.5;
		 0.1, 0.5];

	% Stato iniziale
	x0 = [0, 1]; % x0 = [1, 0] per avere bel tempo il primo giorno

	% Simulo
	f = @(x, t) day(x, P);
	T = 1:30;
	X = simulate(f, T, x0);

	% Disegno l'andamento delle probabilita'
	figure()
	plot(T, X(:, 1), 'b')
	hold on
	plot(T, X(:, 2), 'r')
	hold off
	grid()
end


function xf = day(xc, P)
	xf = P * xc';
	xf = xf';
end
