function es_van_der_pol()
	% Dati del problema
	x0 = 1;
	y0 = 1;
	h = 0.315;
	mu = 1;

	% Simulazione
	f = @(x, t) vdp(x, h, mu);
	T = 1:2000;
	X = simulate(f, T, [x0, y0]);

	% "Spacchetto" le due componenti dello stato
	x = X(:, 1); % Prima colonna
	y = X(:, 2); % Prima colonna

	% Disegno l'andamento nel tempo
	figure()
	plot(T, x)

	% Disegno la traiettoria dello stato
	figure()
	plot(x, y)
	hold on
	scatter(x(1), y(1))
	hold off
	grid()

	% Si puo' anche animare!
	animated_trace(x, y)
end

% Oscillatore di Van Der Pol
function Xf = vdp(X, h, mu)
	% "Spacchetto" lo stato (solo per comodita')
	x = X(1);
	y = X(2);
	% Calcolo lo stato futuro
	Xf(1) = x + h * y;
	Xf(2) = y + h * (mu * (1 - x^2)*y - x);
end
