function es_logi_pp()
	% Parametri del modello
	r = 2.5;
	k = 1000;
	s = 0.010;
	u = 0.5;
	v = 0.3;

	% Stato iniziale
	x0 = [500, 30]; % Al variare del numero di predatori, il sistema
					 % converge sempre verso lo stesso stato finale. Il
					 % modello puo pero' perdere di senso fisico (alcuni
					 % valori di popolazione diventano negativi)
	% Intervallo di simulazione
	T = 1:300;

	% Simulazione
	f = @(x, t) logi_pp(x, r, k, s, u, v);
	X = simulate(f, T, x0);
	x = X(:, 1);
	y = X(:, 2);

	% Disegno l'andamento della popolazione
	figure()
	plot(T, x, 'linewidth', 1.5);
	hold on
	plot(T, y, 'r', 'linewidth', 1.5);
	hold off

	% Disegno la traiettoria nello spazio degli stati
	figure();
	plot(x, y, 'linewidth', 1.5)
	grid()
end

function xf = logi_pp(xc, r, k, s, u, v)
	% xc(1) --> prede
	% xc(2) --> predatori
	xf(1) = r * (1 - xc(1)/k) * xc(1) - (s * xc(1)) * xc(2);
	xf(2) = u * xc(2) + v * s * xc(1) * xc(2);
end

% COMMENTI SULLE VARIAZIONI
% Aumentando s, si aumenta la capacita' di predare dei predatori
% - Il sistema tende a perdere senso fisico, perche' il numero di prede
%	diventa in molti casi negativo
% - Se l'aumento e' sufficientemente piccolo, il numero finale di prede
%	tende a diminuire (come e' intuitivo che succeda)
% - Se s diventa troppo piccolo, i predatori non riescono a sopravvivere
% - Se s cala di molto poco, il numero finale di prede aumenta e quello di
%	predatori diminuisce
%
% Aumentando r si aumenta la capacita' riproduttiva delle prede
% - Il numero di prede tende a variare in modo piu' brusco e cosi' anche
%	quello dei predatori. Ci vogliono piu' passi perche' il sistema si
%	assesti
% - Quando r ragginge il valore 2 il sistema diventa periodico
% - Se r cresce ancora, si tende a perdere il senso fisico (oscillazioni
%	troppo grandi)
% - Se r cala, le prede si riproducono troppo lentamente ed i predatori
%	(fatto interessante) non riescono a sopravvivere
% - Se r cala troppo, si perde il senso fisico
%
% Aumentando u, si aumenta la capacita' dei predatori di sopravvivere senza
% prede.
% - In generale, il numero di predatori tende ad aumentare e quello di
%	prede a diminuire
% - Se u divente troppo grande si perde il senso fisico
% - Se u cala, il numero finale di predatori diminuisce, ma solo
%	leggermente. La diminuzione e' leggera perche' aumenta invece di molto il
%	numero finale di prede (quindi in qualche modo i predatori
%	sopravvivono)
