function logistic_growth()
	% Parametri del modello
	r = 1.2; % Per r = 1.1 la popolazione cala, ma senza raggiungere lo 0
			 % Per r = 1.2 la popolazione cresce e si assesta, senza
			 % oscillazioni
			 % Quando r > 2.0 cominciano ad esserci oscillazioni, ma lo
			 % stato si stabilizza comunque
			 % Per r = 3.1 il comportamento diventa periodico
			 % Quando r supera 3.5, il comportamento diventa caotico

	k = 10000;

	% Stato iniziale
	x0 = 1000;
	% Intervallo di simulazione
	T = 1:100;

	% Simulazione
	f = @(x, t) logi(x, r, k);
	X = simulate(f, T, x0);

	% Disegno l'andamento nel tempo
	figure();
	plot(T, X);
	grid()
	xlabel('Tempo')
	ylabel('Popolazione')
end

function xf = logi(xc, r, k)
	xf = r * xc * (1 - xc/k);
end
