function es_van_der_pol()
	% Dati del problema
	x0 = 1;
	y0 = 1;
	h = 0.1;
	mu = 1;
	A = 1;
	omega = 2 * pi; % Provate anche con 0.06 * 2 * pi! 
	T = 1:1000;

	% Simulazione (oscillatore libero)
	f1 = @(x, t) vdp(x, h, mu);
	X1 = simulate(f1, T, [x0, y0]);
	x1 = X1(:, 1);
	y1 = X1(:, 2);

	% Simulazione (oscillatore forzato)
	f2 = @(x, t) forced_vdp(x, t, omega, A, h, mu);
	X2 = simulate(f2, T, [x0, y0]);
	x2 = X2(:, 1);
	y2 = X2(:, 2);

	% Disegno l'andamento nel tempo
	figure()
	plot(T, x1)
	hold on
	plot(T, x2)
	legend('libero', 'forzato')
	hold off

	% Mostro la traiettoria dello stato per l'oscillatore non forzato
	figure()
	plot(x1, y1)
	grid()

	% Mostro la traiettoria dello stato per l'oscillatore forzato
	figure()
	plot(x2, y2)
	grid()

	% Si puo' anche animare!
	animated_trace(x2, y2)
end

% Oscillatore di Van Der Pol (libero)
function Xf = vdp(X, h, mu)
	% "Spacchetto" lo stato (solo per comodita')
	x = X(1);
	y = X(2);
	% Calcolo lo stato futuro
	Xf(1) = x + h * y;
	Xf(2) = y + h * (mu * (1 - x^2)*y - x);
end

% Oscillatore di Van Der Pol (forzato)
function Xf = forced_vdp(X, t, omega, A, h, mu)
	% "Spacchetto" lo stato (solo per comodita')
	x = X(1);
	y = X(2);
	% Calcolo lo stato futuro
	Xf(1) = x + h * y;
	Xf(2) = y + h * (mu * (1 - x^2)*y - x - A * sin(omega * h * t));
end
