function es_van_der_pol()
    % Dati del problema
    x0 = 1;
	y0 = 1;
	h = 0.05;
	mu = 1;

    % Simulazione
    X = [];
    T = 1:300; % Istanti di tempo
    xc = [x0, y0]; % Stato iniziale
    for t = T
        X(t, :) = xc; % Salvo lo stato corrente
        xc = f(xc, h, mu); % Genero lo stato futuro
    end

	% "Spacchetto" le due componenti dello stato
	x = X(:, 1); % Prima colonna
	y = X(:, 2); % Prima colonna

    % Disegno l'andamento nel tempo
    plot(T, x)
end


function Xf = f(X, h, mu)
	% "Spacchetto" lo stato
	x = X(1);
	y = X(2);
	% Calcolo lo stato futuro
    Xf(1) = x + h * y;
	Xf(2) = y + h * (mu * (1 - x^2)*y - x);
end
