function es_shepherd()
    % Stato iniziale
    x0 = 100;
    r = 2.0; % Minimo valore di r tale che la popolazione si assesta su k
    N = 1000;

    % Simulazione
    T = 1:100;
    xc = x0;
    for t = T
        X(t) = xc;
        xc = f(xc, r, N);
    end
    X(end) = xc; % Salvo l'ultimo valore dello stato

    % Disegno l'andamento della popolazione
    figure()
    plot(T, X);
end

function xf = f(x, r, N)
    xf = (r .* x) ./ (1 + (x./N).^2);
end
